package com.clx.performance.dao.impl.integral;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.integral.IntegralTruckRuleDao;
import com.clx.performance.mapper.integral.IntegralTruckRuleMapper;
import com.clx.performance.model.integral.IntegralTruckRule;
import com.clx.performance.param.pc.integral.PageIntegralTruckRuleParam;
import com.clx.performance.vo.pc.integral.AppIntegralTruckRuleVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分车辆规则
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralTruckRuleDaoImpl extends BaseDaoImpl<IntegralTruckRuleMapper, IntegralTruckRule, Integer> implements IntegralTruckRuleDao {

    @Override
    public boolean update(IntegralTruckRule item) {
        return update(lUdWrapper()
                .eq(IntegralTruckRule::getId, item.getId())
                .set(IntegralTruckRule::getStatus, item.getStatus())
                .set(IntegralTruckRule::getName, item.getName())
                .set(IntegralTruckRule::getIntegralRatioBegin, item.getIntegralRatioBegin())
                .set(IntegralTruckRule::getIntegralRatioEnd, item.getIntegralRatioEnd())
                .set(IntegralTruckRule::getIncomeBegin, item.getIncomeBegin())
                .set(IntegralTruckRule::getIncomeEnd, item.getIncomeEnd())
        );
    }

    @Override
    public boolean updateStatus(IntegralTruckRule item) {
        return update(lUdWrapper()
                .eq(IntegralTruckRule::getId, item.getId())
                .set(IntegralTruckRule::getStatus, item.getStatus())
        );
    }

    @Override
    public List<IntegralTruckRule> listAllRule() {
        return list(lQrWrapper().orderByAsc(IntegralTruckRule::getIntegralRatioBegin));
    }

    @Override
    public IPage<AppIntegralTruckRuleVO> pageRule(PageIntegralTruckRuleParam param) {
        Page<AppIntegralTruckRuleVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageRule(page,param);
    }
}
