package com.clx.performance.dao.impl.breakcontract;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.mapper.breakcontract.BreakContractSettlementDriverMapper;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Repository
public class BreakContractSettlementDriverDaoImpl extends BaseDaoImpl<BreakContractSettlementDriverMapper, BreakContractSettlementDriver, Integer> implements BreakContractSettlementDriverDao {
    @Override
    public boolean updateSettlementStatus(BreakContractSettlementDriver item) {
        return update(lUdWrapper()
                .eq(BreakContractSettlementDriver::getId, item.getId())
                .set(BreakContractSettlementDriver::getSettleStatus, item.getSettleStatus())
                .set(BreakContractSettlementDriver::getSettleTime, item.getSettleTime())
        );
    }

    @Override
    public boolean updatePayFail(BreakContractSettlementDriver item) {
        return update(lUdWrapper()
                .eq(BreakContractSettlementDriver::getId, item.getId())
                .set(BreakContractSettlementDriver::getPayRemark, item.getPayRemark())
        );
    }

    @Override
    public Optional<BreakContractSettlementDriver> selectBySettlementNo(String settlementNo) {
        return Optional.of(settlementNo)
                .map(item -> lQrWrapper()
                        .eq(BreakContractSettlementDriver::getSettlementNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<BreakContractSettlementDriver> pageCarrierBreakContractSettlementDriverList(PageCarrierBreakContractSettlementDriverParam param) {

        LambdaQueryWrapper<BreakContractSettlementDriver> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getChildNo()),BreakContractSettlementDriver :: getChildNo,param.getChildNo());
        query.like(StringUtils.isNotBlank(param.getTruckOwnName()),BreakContractSettlementDriver :: getTruckOwnName,param.getTruckOwnName());
        query.eq(StringUtils.isNotBlank(param.getSettlementNo()),BreakContractSettlementDriver :: getSettlementNo,param.getSettlementNo());
        query.eq(Objects.nonNull(param.getSettleStatus()),BreakContractSettlementDriver :: getSettleStatus,param.getSettleStatus());
        query.eq(Objects.nonNull(param.getTruckOwnUserNo()),BreakContractSettlementDriver :: getTruckOwnUserNo,param.getTruckOwnUserNo());
        query.eq(Objects.nonNull(param.getBreakContractPartyType()),BreakContractSettlementDriver :: getBreakContractPartyType,param.getBreakContractPartyType());
        query.ge(StringUtils.isNotBlank(param.getBeginTime()),BreakContractSettlementDriver :: getCreateTime,param.getBeginTime());
        query.le(StringUtils.isNotBlank(param.getEndTime()),BreakContractSettlementDriver :: getCreateTime,param.getEndTime());
        query.orderByDesc(BreakContractSettlementDriver::getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);

    }

    @Override
    public List<BreakContractSettlementDriver> listUnpay(LocalDateTime beginTime) {
        return list(lQrWrapper()
                        .eq(BreakContractSettlementDriver::getSettleStatus, BreakContractSettlementDriverEnum.SettleStatus.NO.getCode())
                        .gt(BreakContractSettlementDriver::getCreateTime, beginTime)
                );
    }
}
