package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PageIntegralStatisticsParam;
import com.clx.performance.param.pc.pageIntegralStatisticsDetailParam;
import com.clx.performance.service.IntegralStatisticsService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.IntegralRecordVO;
import com.clx.performance.vo.pc.IntegralStatisticsVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral")
@Validated
@Api(tags = "承运端-积分统计")
@AllArgsConstructor
public class IntegralStatisticsController {

    private final IntegralStatisticsService integralStatisticsService;

    @ApiOperation(value = "获取积分统计列表", notes = "<br>By:艾庆国")
    @PostMapping(value = "pageStatisticsList")
    public Result<PageData<IntegralStatisticsVO>> pageStatisticsList(@RequestBody @Validated PageIntegralStatisticsParam param) {

        if (StringUtils.isNotBlank(param.getBeginTime())){param.setBeginTime(LocalDateTimeUtils.getWeekStart(param.getBeginTime()));}
        if (StringUtils.isNotBlank(param.getEndTime())){
            if (LocalDateTimeUtils.parseTime(param.getEndTime()).isAfter(LocalDateTime.now())){param.setEndTime(LocalDateTimeUtils.getWeekStart());}
            else {param.setEndTime(LocalDateTimeUtils.getWeekStart(param.getEndTime()));}
        }
        else {param.setEndTime(LocalDateTimeUtils.getWeekStart());}

        IPage<IntegralStatisticsVO> page = integralStatisticsService.pageStatisticsList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

    @ApiOperation(value = "获取积分统计明细列表", notes = "<br>By:艾庆国")
    @PostMapping(value = "pageStatisticsDetailList")
    public Result<PageData<IntegralRecordVO>> pageStatisticsDetailList(@RequestBody @Validated pageIntegralStatisticsDetailParam param) {

        IPage<IntegralRecordVO> page = integralStatisticsService.pageStatisticsDetailList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

}
