package com.clx.performance.param.pc.payment;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class PayParam {
	@NotBlank(message = "支付人不能为空")
	@ApiModelProperty(value = "支付来源", example = "2234", dataType = "int")
	Integer from;
	@NotBlank(message = "支付密码不能为空")
	@ApiModelProperty(value = "支付方密码", example = "2356", dataType = "String")
	String pwd;
	@NotBlank(message = "收款钱包不能为空")
	@ApiModelProperty(value = "支付去向", example = "2234", dataType = "int")
	Integer to;
	@NotBlank(message = "金额不能为空")
	@ApiModelProperty(value = "金额", example = "2356", dataType = "int")
	Integer figure;
	@NotBlank(message = "交易单号不能为空")
	@ApiModelProperty(value = "交易单号", example = "2356", dataType = "String")
	String tradeNo;
	@NotBlank(message = "交易单id不能为空")
	@ApiModelProperty(value = "交易单id", example = "23", dataType = "int")
	String tradeId;
	@NotBlank(message = "交易备注不能为空")
	@ApiModelProperty(value = "交易备注", example = "23", dataType = "int")
	String remark;


}
