package com.clx.performance.param.pc;

import com.clx.performance.param.app.PositionParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class SettlementInvoiceExpressParam extends PositionParam {

    @ApiModelProperty(value = "结算id", example = "1")
    @NotNull(message = "结算id不能为空")
    private Integer settlementId;

    @ApiModelProperty(value = "快递公司", example = "顺丰")
    @NotBlank(message = "快递公司不能为空")
    private String expressCompany;

    @ApiModelProperty(value = "快递编号", example = "1000000")
    @NotBlank(message = "快递编号不能为空")
    private String expressNo;

}
