package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckLeaveSaveParam {

    @ApiModelProperty(value = "请假开始时间")
    @NotBlank(message = "请假开始时间不能为空")
    private String beginTime;
    @ApiModelProperty(value = "请假结束时间")
    @NotBlank(message = "请假结束时间不能为空")
    private String endTime;
    @ApiModelProperty(value = "请假原因")
    @NotBlank(message = "请假原因不能为空")
    private String remark;

}
