package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildEstimatedFreightParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    @NotNull(message = "装货净重不能为空")
    private BigDecimal loadNet;

}
