package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum SettlementPlatformEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum Platform {
        MSL(1, "马上来"),
        WY(2, "网运平台");
        private final Integer code;
        private final String msg;

        public static Optional<Platform> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Platform::getMsg).orElse(null);
        }
    }





}
