package com.clx.performance.common;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @Author: aiqingguo
 * @Description:
 * @Date: 2023-10-12 11:59:33
 * @Version: 1.0
 */
@Getter
@Setter
@NoArgsConstructor
public class MqWrapper<T> {
    
    private T data;
    private String exchange;        //交换机
    private String routeKey;        //路由键
    private String createTime;      //创建时间

    public MqWrapper(T data) {
        this.data = data;
        this.createTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
    }

    public MqWrapper(T data, String exchange, String routeKey) {

        this.data = data;
        this.exchange = exchange;
        this.routeKey = routeKey;
        this.createTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
    }

}
