package com.clx.performance.service.impl;

import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.LastTruckService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @ClassName LastTruckServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/11/9 13:13
 * @Version 1.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class LastTruckServiceImpl implements LastTruckService {

    private final OrderFeign orderFeign;
    private final OrderChildDao orderChildDao;
    /**
     * @Author kavin
     * @Description 判断最后一车的逻辑
     * @Param [orderNo]
     * @return
     **/
    @Override
    public OrderChild getLastTruckChild(String orderNo) {
        FeignOrderVO orderInfo = orderFeign.getOrderInfoFeign(orderNo);
        if(Objects.isNull(orderInfo)){
            log.error("计算最后一车，通过订单号:{},未查询到对应的订单",orderNo);
            return null;
        }
        BigDecimal weight = orderChildDao.listAfterArrayReceiveChild(orderNo);
        //判断当前订单下所有到达目的地之后的运单的装车吨数 + 向下浮动量 >= 订单拉运吨数
        log.info("订单号:{} ,计算是否到达可计算最后一车标准，运单累计拉运吨数：{}, 向下浮动量:{},订单拉运吨数:{}",
                orderNo,weight,orderInfo.getDownFloatWeight(),orderInfo.getTransportWeight());
        if(Objects.nonNull(weight) && weight.add(new BigDecimal(orderInfo.getDownFloatWeight())).compareTo(orderInfo.getTransportWeight()) >= 0){
            //查询最后一车的运单
            OrderChild child = orderChildDao.getLastTruckChild(orderNo);
            log.info("当前订单计算出最后一车，运单编号：{} ", child.getChildNo());
            return child;
        }
        return  null;
    }
}
