package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.mapper.OrderChildMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.app.PageOrderChildOfDriverSearchParam;
import com.clx.performance.param.pc.*;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.PageCarrierOrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import com.msl.common.base.Optional;
import com.msl.common.base.PageParam;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
public interface OrderChildDao extends BaseDao<OrderChildMapper, OrderChild, Integer> {

    boolean updateStatus(OrderChild item);

    boolean updateArriveReceiveAddress(OrderChild item);

    boolean updateLoad(OrderChild item);
    boolean updateUnload(OrderChild item);
    boolean updateLoadAndUnload(OrderChild item);
    boolean updatePoundAuditStatus(OrderChild item);
    boolean updateDriverConfirm(OrderChild item);
    boolean updateSettlement(OrderChild item);

    boolean updateCancel(OrderChild item);


    Optional<OrderChild> getByChildNo(String childNo);

    long countOfCancel(Long userNo, LocalDateTime startTime, LocalDateTime endTime);
    long countOfTransitByOrderGoodsNo(String orderGoodsNo);

    IPage<OrderChildVO> pageOrderChildOfDriver(PageOrderChildOfDriverParam param);
    IPage<OrderChildVO> pageSearchOrderChildOfDriver(PageOrderChildOfDriverSearchParam param);

    IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param);

    IPage<PageCarrierOrderChildVO> pageCarrierOrderChildList(PageCarrierOrderChildParam param);

    Optional<List<OrderChild>> getOrderChildInfoByOrderGoodsNo(String childNo);

    OrderChild getGoingLatestOrderChild(Long driverUserNo);

    int countValidByOrderGoodsNo(String orderGoodsNo);

    Integer getOrderChildTotalByUserNo(Long userNo);

    List<OrderChild> getOrderChildBussInfo(String truckNo);

    List<OrderChild> selectListByOrderGoodsNo(String orderGoodsNo);

    Page<OrderChild> pageOrderChild(PageMonitorOrderChildQCParam param);

    List<OrderChild> listOrderChild(List<Integer> status);

    List<OrderChild> getOrderChildByOrderNo(String orderNo);

    boolean updateArriveSendAddress(OrderChild orderChild);

    int countCompleteByTruckNoAndPayFinishTime(@Param("truckNo") String truckNo,
                                               @Param("beginTime")String beginTime,
                                               @Param("endTime")String endTime,
                                               @Param("confirmTime")String confirmTime,
                                               @Param("list")List<String> orderGoodsNoList
    );

    OrderChild getGoingLatestOrderChildByOrderNo(String orderNo);

    List<OrderChild> selectResidueWeight(String orderNo,Integer status);

    List<OrderChild> selectResidueWeightByOrderGoodsNo(String orderGoodsNo,Integer status);

    List<OrderChild> selectResidueWeightByOrderGoodsNo(String orderGoodsNo,Integer status,List<String> truckList);

    /**
     * 查询未到达货源地的运单
     * @param orderGoodsNo
     * @return
     */
    List<OrderChild> selectArriveSendOrderChild(String orderGoodsNo);

    /**
     * 查询到达货源地之后的运单
     * @param orderGoodsNo
     * @return
     */
    List<OrderChild> selectArriveSendOrderChildGe(String orderGoodsNo);


    void batchUpdateOrderChildStatus(Integer status, String remark, String cancelTime, String finishTime, List<String> childNoList);

    List<OrderChild> selectOrderChildListByOrderGoodsNoAndStatusGE(String orderGoodsNo, Integer status);

    List<OrderChild> selectListByOrderGoodsList(List<String> orderGoodsList);

    List<OrderChild> listOrderChildByOrderNoAndStatus(String orderNo,List<Integer> status);

    /**
     * 通过订单号查询在途运单
     * @param orderNo
     * @return
     */
    List<OrderChild> selectInTransitOrderChild(String orderNo);

    /**
     * 通过货单号查询在途运单
     * @param orderGoodsNo
     * @return
     */
    List<OrderChild> selectInTransitOrderChildByOrderGoodsNo(String orderGoodsNo);

    OrderChild findLastTruckChild(String orderNo);

    BigDecimal listAfterArrayReceiveChild(String orderNo);

    OrderChild getLastTruckChild(String orderNo);
    BigDecimal getLinePoundDifferenceRatioAvg(@Param("sendSystemAddressId") Integer sendSystemAddressId,
                                              @Param("receiveSystemAddressId") Integer receiveSystemAddressId,
                                              @Param("beginTime") String beginTime);
    Integer getLineArriveSendAddressToUnloadTimeAvg(@Param("sendSystemAddressId") Integer sendSystemAddressId,
                                        @Param("receiveSystemAddressId") Integer receiveSystemAddressId,
                                        @Param("beginTime") String beginTime);

    void updateSendSystemAddress(Integer ownerAddressId, Integer systemAddressId);
    void updateReceiveSystemAddress(Integer ownerAddressId, Integer systemAddressId);

    /**
     * 客服查询可以取消的运单
     * @param orderChildNo
     * @return
     */
    OrderChildVO findArtificialCancelOrder(String orderChildNo);

    IPage<OrderChildVO> orderChildCancelRecord(OrderChildCancelRecordParam param);

    List<OrderChild> selectInOrderChildNoList(List<String> childNoList);
    List<Double> getLossNet(OrderChildReportParam param);

}
