package com.clx.performance.dto.zjxl;

import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.zjxl.ZJXLPositionUtils;

import java.math.BigDecimal;

/**
 * @ClassName TruckLocationDTO
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:13
 * @Version 1.0
 */
public class TruckLocationDTO {

    private String truckNo;
    private BigDecimal angle;
    private BigDecimal speed;
    private BigDecimal[] location;
    private String gpsTime;
    private String province;
    private String city;
    private String country;
    private String address;
    private String createTime;
    private String modifiedTime;

    public TruckLocationDTO(String angle, String speed, String lon, String lat, String gpsTime, String province, String city, String country, String address) {
        this.angle = new BigDecimal(angle);
        this.speed = ZJXLPositionUtils.speedFormat(speed);
        this.location = ZJXLPositionUtils.WGS484Format(lon, lat);
        this.gpsTime = LocalDateTimeUtils.getFormatByLong(Long.parseLong(gpsTime), (String)null);
        this.province = province;
        this.city = city;
        this.country = country;
        this.address = address;
    }



}
