package com.clx.performance.param.pc.loan.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BorrowerAddParam {

    @ApiModelProperty(value = "借出方", example = "张三")
    @NotBlank(message = "借出方不能为空")
    private String name;
    @ApiModelProperty(value = "所属银行", example = "工商银行")
    @NotBlank(message = "所属银行不能为空")
    private String bankName;
    @ApiModelProperty(value = "银行账号", example = "10000000000000000")
    @NotBlank(message = "银行账号不能为空")
    private String bankCardNo;

    @ApiModelProperty(value = "开户行行号", example = "313332082914")
    @NotBlank(message = "开户行行号不能为空")
    private String openBankId;
    @ApiModelProperty(value = "开户行", example = "宁波银行")
    @NotBlank(message = "开户行不能为空")
    private String openBankName;

}
