package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
* @Author: aiqinguo
* @Description: 积分车辆
* @Date: 2023-10-10 20:33:10
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class IntegralTruck implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String truckNo;                         //车牌号
    private String driverName;                      //司机姓名
    private String driverMobile;                    //司机手机号
    private Integer echelon;                        //梯队
    private Integer integral;                       //积分
    private Integer rank;                           //排名
    private String createTime;                      //创建时间
    private String modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}