package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.*;

/**
* @Author: aiqinguo
* @Description: 积分记录
* @Date: 2023-10-11 17:30:51
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class IntegralRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer statisticsId;                   //统计id
    private String statisticsDate;                 //统计时间
    private String truckNo;                         //车牌号
    private Integer integral;                       //获得积分
    private Integer type;                           //类型
    private String remark;                          //原因
    private String createTime;                      //创建时间
    private String modifiedTime;                    //修改时间


    @Getter
    @AllArgsConstructor
    public enum type{
        SYSTEM(1, "系统"),
        PROTECTION(2, "保护分"),
        PROTECTION_CANCEL(3, "保护分取消"),
        SETTLEMENT(4, "结算分"),
        BASE(5, "基础分"),

        ORDER_CHILD_COMPLETE(11, "运单完成"),
        ORDER_CHILD_COMPLETE_NUM(12, "运单完成数量"),
        ORDER_CHILD_COMPLETE_WATER(13, "流水单"),
        ORDER_CHILD_COMPLETE_SUPPORT(14, "支援单"),
        ORDER_CHILD_COMPLETE_TIMEOUT(15, "运单完成超时"),

        ORDER_CHILD_CANCEL(21, "运单取消"),
        ORDER_CHILD_CANCEL_TIMEOUT(22, "运单取消超时"),
        ;

        private Integer value;
        private String msg;
    }

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}