package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.mapper.OrderChildMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.app.PageOrderChildOfDriverSearchParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.param.pc.PageMonitorOrderChildQCParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.PageCarrierOrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildDaoImpl extends BaseDaoImpl<OrderChildMapper, OrderChild, Integer> implements OrderChildDao {

    @Override
    public boolean updateStatus(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateLoad(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getLoadRough, item.getLoadRough())
                .set(OrderChild::getLoadTare, item.getLoadTare())
                .set(OrderChild::getLoadNet, item.getLoadNet())

                .set(OrderChild::getLoadTime, item.getLoadTime())
                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getFreight, item.getFreight())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateUnload(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getUnloadPoundNo, item.getUnloadPoundNo())
                .set(OrderChild::getUnloadRough, item.getUnloadRough())
                .set(OrderChild::getUnloadTare, item.getUnloadTare())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())

                .set(OrderChild::getUnloadTime, item.getUnloadTime())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
                .set(OrderChild::getFreight, item.getFreight())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateLoadAndUnload(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())

                .set(OrderChild::getUnloadPoundNo, item.getUnloadPoundNo())
                .set(OrderChild::getLoadRough, item.getLoadRough())
                .set(OrderChild::getLoadTare, item.getLoadTare())
                .set(OrderChild::getLoadNet, item.getLoadNet())

                .set(OrderChild::getUnloadRough, item.getUnloadRough())
                .set(OrderChild::getUnloadTare, item.getUnloadTare())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())

                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getFreight, item.getFreight())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
        );
    }

    @Override
    public boolean updatePoundAuditStatus(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
                .set(OrderChild::getLoadNet, item.getLoadNet())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())
                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getFreight, item.getFreight())
        );
    }

    @Override
    public boolean updateDriverConfirm(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateCancel(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getId, item.getId())
                .set(OrderChild::getCancelRemark, item.getCancelRemark())
                .set(OrderChild::getCancelTime, item.getCancelTime())
                .set(OrderChild::getFinishTime, item.getFinishTime())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }


    @Override
    public Optional<OrderChild> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(OrderChild::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public long countOfCancel(Long userNo, LocalDateTime startTime, LocalDateTime endTime) {
        return count(lQrWrapper()
                .eq(OrderChild::getUserNo, userNo)
                .eq(OrderChild::getStatus, OrderChildEnum.Status.DRIVER_CANCEL.getCode())
                .ge(OrderChild::getCreateTime, startTime)
                .le(OrderChild::getCreateTime, endTime)
        );
    }

    @Override
    public long countOfTransitByOrderGoodsNo(String orderGoodsNo) {
        return count(lQrWrapper()
                .eq(OrderChild::getOrderGoodsNo, orderGoodsNo)
                .lt(OrderChild::getStatus, OrderChildEnum.Status.UNSETTLE.getCode())
        );
    }

    @Override
    public IPage<OrderChildVO> pageOrderChildOfDriver(PageOrderChildOfDriverParam param) {
        Page<OrderChildVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageOrderChildOfDriver(page,param);
    }

    @Override
    public IPage<OrderChildVO> pageSearchOrderChildOfDriver(PageOrderChildOfDriverSearchParam param) {
        Page<OrderChildVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageSearchOrderChildOfDriver(page,param);
    }

    @Override
    public IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param) {
        Page<PageOrderChildPoundAuditVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pagePoundAuditList(page,param);
    }

    @Override
    public IPage<PageCarrierOrderChildVO> pageCarrierOrderChildList(PageCarrierOrderChildParam param) {
        Page<PageCarrierOrderChildVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageCarrierOrderChildList(page,param);
    }

    @Override
    public Optional<List<OrderChild>> getOrderChildInfoByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(list(lQrWrapper().eq(OrderChild::getOrderGoodsNo, orderGoodsNo)));
    }

    @Override
    public OrderChild getGoingLatestOrderChild(Long driverUserNo) {
        return getOne(lQrWrapper().eq(OrderChild::getDriverUserNo,driverUserNo)
                .le(OrderChild::getStatus,OrderChildEnum.Status.UNLOAD.getCode())
                .orderByDesc(OrderChild::getId)
                .last("limit 1"));
    }

    @Override
    public int countValidByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.countValidByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public Integer getOrderChildTotalByUserNo(Long userNo) {
        LambdaQueryWrapper<OrderChild> query = new LambdaQueryWrapper();
        query.eq(OrderChild :: getUserNo,userNo);
        query.in(OrderChild :: getStatus,OrderChildEnum.Status.UNSETTLE.getCode(),OrderChildEnum.Status.COMPLETE.getCode());
        return baseMapper.selectCount(query).intValue();
    }

    @Override
    public Page<OrderChild> pageOrderChild(PageMonitorOrderChildQCParam param) {
        LambdaQueryWrapper<OrderChild> query = new LambdaQueryWrapper();

        if(StringUtils.isNotBlank(param.getTruckNo())){
            query.eq(OrderChild :: getTruckNo,param.getTruckNo());
        }
        if(Objects.nonNull(param.getSendAddressId())){
            query.eq(OrderChild :: getSendAddressId,param.getSendAddressId());
        }
        query.in(OrderChild :: getStatus,param.getStatus());
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);

    }

    @Override
    public List<OrderChild> getOrderChildByOrderNo(String orderNo) {
        LambdaQueryWrapper<OrderChild> query = new LambdaQueryWrapper();
        query.in(OrderChild :: getOrderNo,orderNo);
        return baseMapper.selectList(query);
    }

    @Override
    public List<OrderChild> listOrderChild(List<Integer> status) {
        LambdaQueryWrapper<OrderChild> query = new LambdaQueryWrapper();
        query.in(OrderChild :: getStatus,status);
        return baseMapper.selectList(query);

    }


    @Override
    public List<OrderChild> getOrderChildBussInfo(String truckNo) {
        LambdaQueryWrapper<OrderChild> query = new LambdaQueryWrapper();
        query.eq(OrderChild::getTruckNo, truckNo)
                .in(OrderChild::getStatus, OrderChildEnum.Status.UNSETTLE.getCode(),OrderChildEnum.Status.COMPLETE.getCode());
        return baseMapper.selectList(query);
    }

}
