package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.IntegralRecordDao;
import com.clx.performance.mapper.IntegraRecordMapper;
import com.clx.performance.model.IntegralRecord;
import com.clx.performance.param.pc.pageIntegralStatisticsDetailParam;
import com.clx.performance.vo.pc.IntegralRecordVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;


/**
 * @Author: aiqinguo
 * @Description: 积分记录
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralRecordDaoImpl extends BaseDaoImpl<IntegraRecordMapper, IntegralRecord, Integer> implements IntegralRecordDao {

    @Override
    public IPage<IntegralRecordVO> pageByParam(pageIntegralStatisticsDetailParam param) {
        return baseMapper.pageByParam(Page.of(param.getPage(), param.getPageSize()), param);
    }

    @Override
    public Integer sumIntegral(Integer statisticsId) {
         return Optional.ofNullable(getOne(qrWrapper()
                .select("sum(integral) as integral")
                .eq("statistics_id", statisticsId))).map(item->item.getIntegral()).orNull();
    }

}
