package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.IntegralStatisticsMapper;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.param.pc.PageIntegralStatisticsParam;
import com.clx.performance.vo.pc.IntegralStatisticsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分排名统计
 * @Date: 2023-10-9 11:55:36
 * @Version: 1.0
 */
public interface IntegralStatisticsDao extends BaseDao<IntegralStatisticsMapper, IntegralStatistics, Integer> {

    boolean updateIntegral(IntegralStatistics item);

    boolean batchUpdateRank(List<IntegralStatistics> list);

    Optional<IntegralStatistics> selectByTruckNoAndStatisticsDate(@Param("truckNo")String truckNo, @Param("statisticsDate")String statisticsDate);

    IPage<IntegralStatisticsVO> pageByParam(PageIntegralStatisticsParam param);

    Optional<IntegralStatistics> selectById(Integer id);

    List<IntegralStatistics> selectByStatisticsDate(@Param("statisticsDate")String statisticsDate);

}
