package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.IntegralTruckAddParam;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.service.IntegralTruckService;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral")
@Validated
@Api(tags = "承运端-积分车辆")
@AllArgsConstructor
public class IntegralTruckController {

    private final IntegralTruckService integralTruckService;

    @Deprecated
    @ApiOperation(value = "新增车辆", notes = "<br>By:艾庆国")
//    @PostMapping("/saveTruck")
    public Result<Void> saveTruck(@RequestBody @Validated IntegralTruckAddParam param) {
        integralTruckService.saveTruck(param);

        return Result.ok();
    }

    @Deprecated
    @ApiOperation(value = "获取车辆列表", notes = "<br>By:艾庆国")
//    @PostMapping(value = "pageTruckList")
    public Result<PageData<IntegralTruckVO>> pageTruckList(@RequestBody @Validated PageIntegralTruckParam param) {

        IPage<IntegralTruckVO> page = integralTruckService.pageTruckList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "查询车辆所属司机信息", notes = "<br>By:艾庆国")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "truckNo", value = "车牌号", paramType = "query", example = "京A123456")
    })
    @GetMapping(value = "getTruckDriverInfo")
    public Result<IntegralTruckVO> getTruckDriverInfo(@Validated @NotBlank(message = "车牌不能为空") String truckNo) {

        return Result.ok(integralTruckService.getTruckDriverInfo(truckNo));
    }

    @ApiOperation(value = "获取车辆数量", notes = "<br>By:艾庆国")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "truckEchelon", value = "车辆梯队", paramType = "query", example = "1")
    })
    @GetMapping(value = "getTruckCount")
    public Result<Integer> getTruckCount(@Validated @NotNull(message = "车辆梯队不能为空") Integer truckEchelon) {

        return Result.ok(integralTruckService.getTruckCount(truckEchelon));
    }

}
