package com.clx.performance.utils;
 
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.geo.*;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
 
import java.util.ArrayList;
import java.util.List;
 
/*
 *
 */
@Component
public class RedisGeoUntil {
 
	@Autowired
	private  RedisTemplate redisTemplate;
 
 
	/*
	    新增
	 */
	public void insertRedisGeo(String redisKey , Double longitudeX,Double latitudeY,String code){
		//增加(添加经纬度信息)
		//Point的属性值，x轴是经度longitude，y轴是纬度latitude。
		Point point  = new Point(longitudeX,latitudeY);
		Long addedNum = redisTemplate.opsForGeo().add(redisKey,point,code);
		System.out.println(addedNum);
	}



	/**
	 * @Author kavin
	 * @Description 删除所有的geo数据
	 * @Param [redisKey]
	 * @return
	 **/
	public void deleteAllRedisGeo(String redisKey){
		//删除
		redisTemplate.delete(redisKey);
	}

 
	/*
	      删除
	 */
	public void deleteRedisGeo(String redisKey , String code){
		//删除
		//redisTemplate.opsForZSet().remove(redisKey,"hangzhou5");
		Long remove = redisTemplate.boundZSetOps(redisKey).remove(code);
		System.out.println(remove);
	}
 
 
	/*
	      修改
	 */
	public void updateRedisGeo(String redisKey, Double longitudeX,Double latitudeY , String code){
		//修改(先删除再新增)
		deleteRedisGeo(  redisKey ,   code);
		insertRedisGeo(  redisKey ,   longitudeX,  latitudeY,  code);
		System.out.println();
	}
 
 
	/*
	     查询多个
	 */
	public List<Point> getRedisGeoList(String redisKey , List<String> codeList) {
		List<Point> pointList = new ArrayList<>();
		for(int i = 0 ; i < codeList.size();i++){
			Point redisGeo = getRedisGeo(redisKey, codeList.get(i));
			if(redisGeo != null){
				pointList.add(redisGeo);
			}
		}
		System.out.println(pointList);
		return pointList;
	}
 
 
	/*
	     查询单个
	 */
	public Point getRedisGeo(String redisKey , String code) {
		//查询可以查询多个 经纬度
		List<Point> pointsAll = redisTemplate.opsForGeo().position(redisKey,code);
		System.out.println(pointsAll);
		if(!CollectionUtils.isEmpty(pointsAll)){
			return pointsAll.get(0);
		}
		return null;
	}
 
 
	/**
	 * 计算指定点 5km内的(MaxInteger KM)
	 */
	public GeoResults<RedisGeoCommands.GeoLocation<String>> getRedisGeoMaxIntegerKm(String redisKey   , String  code) {
		Distance disFiveKmFive = new Distance(Integer.MAX_VALUE, Metrics.KILOMETERS);
		RedisGeoCommands.GeoRadiusCommandArgs argsFiveKmFive = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates().sortAscending().limit(5);
		GeoResults<RedisGeoCommands.GeoLocation<String>> resultsFiveKmFive = redisTemplate.opsForGeo().radius(redisKey,code,disFiveKmFive,argsFiveKmFive);
		System.out.println(resultsFiveKmFive);
		return  resultsFiveKmFive;
	}
 
	/**
	 * //中心点设置  某个经纬度算距离
	 */
	public GeoResults<RedisGeoCommands.GeoLocation<String>> getRedisGeoMaxIntegerKm(String redisKey , Double longitudeX,Double latitudeY,Integer limit) {
		//longitude,latitude
		//中心点设置  某个经纬度算距离
		Point pointCenter = new Point(longitudeX,latitudeY);
		Distance distanceCenter = new Distance(Integer.MAX_VALUE, RedisGeoCommands.DistanceUnit.KILOMETERS);
		Circle circleCenter = new Circle(pointCenter, distanceCenter);
		RedisGeoCommands.GeoRadiusCommandArgs argsCircle = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates().sortAscending().limit(limit);
		GeoResults<RedisGeoCommands.GeoLocation<String>> resultsDis = redisTemplate.opsForGeo().radius(redisKey,circleCenter ,argsCircle);
		System.out.println(resultsDis);
		return resultsDis;
	}
 
 
	/*
	     查询单个Hash
	 */
	public List<String> getRedisGeoListHash(String redisKey ,  String code) {
		List<String> resultsHash = redisTemplate.opsForGeo().hash(redisKey,code);
		System.out.println(resultsHash);
		return resultsHash;
	}
 
	/*
	     //计算2地之间距离(返回两个地方的距离，可以指定单位，比如米m，千米km，英里mi，英尺ft)
	 */
	public Distance getRedisGeoListTwoSpace(String redisKey , String  codeOne,String codeTwo) {
		Distance disTwoPlace = redisTemplate.opsForGeo().distance(redisKey,codeOne,codeTwo, RedisGeoCommands.DistanceUnit.KILOMETERS);
		System.out.println(disTwoPlace);
		return disTwoPlace;
	}
 
 
 
}