package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.struct.OrderGoodsStruct;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Service
public class OrderGoodsServiceImpl implements OrderGoodsService {

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private OrderGoodsStruct orderGoodsStruct;

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNo(String orderGoodsNo) {
        return orderGoodsDao.getOrderGoodsInfoByOrderGoodsNo(orderGoodsNo).map(orderGoodsStruct::convert).get();
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        return orderGoodsDao.pageOrderGoodsList(param);
    }
}
