package com.clx.performance.job;

import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.zjxl.ZjxlGpsService;
import com.clx.user.feign.UserClxFeign;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.job.JobLog;
import com.msl.common.result.Result;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

@Slf4j
@Component
public class TruckTraceJob {

    @Autowired(required = false)
    UserClxFeign userClxFeign;
    @Autowired
    ZjxlGpsService zjxlGpsService;
    @Autowired
    RedisTemplate redisTemplate;


    /**
     * 驾驶证过期
     */
    @XxlJob("truckTrace")
    public void truckTrace() {
        try {
            getPlatformTruckTrace();
        } catch (Exception e) {
            log.warn("定时任务获取平台车辆定位信息失败，异常原因:{}",e);
            JobLog.error("定时任务获取平台车辆定位信息失败，异常原因=====================", e);
        }
    }

    /**
     * @Author kavin
     * @Description 定时获取平台车辆的定位
     * @Param []
     * @return
     **/
    public void getPlatformTruckTrace(){
        Result<List<String>> result = userClxFeign.getPlatformTruckList();
        log.info("通过clx-user服务获取平台认证成功车辆，返回结果:{}",result);
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime beginTime = now.plus(-5, ChronoUnit.MINUTES);
        if(Objects.equals(result.getCode(), ResultCodeEnum.SUCCESS.getCode())){
            List<String> truckNos = result.getData();
            for(String truckNo : truckNos){
                List<TruckTraceDTO> truckTrace = zjxlGpsService.getTruckTrace(truckNo,
                        LocalDateTimeUtils.formatTime(beginTime), LocalDateTimeUtils.formatTime(now));

                if(CollectionUtils.isNotEmpty(truckTrace)){
                    //排序获取最新的定位位置
                    truckTrace.stream().sorted(Comparator.comparing(TruckTraceDTO::getGpsTime));
                    TruckTraceDTO truckTraceDTO = truckTrace.get(0);
                    truckTraceDTO.setTruckNo(truckNo);
                    redisTemplate.opsForHash().put(RedisConstants.ZJXL_TRUCK_TRACE_LIST,truckNo,truckTraceDTO);
                }
            }
        }else{
            log.info("通过clx-user服务获取平台认证成功车辆，获取失败");
        }
    }


}
