package com.clx.performance.dto.zjxl;

import com.clx.performance.utils.zjxl.ZJXLPositionUtils;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName TruckTraceDTO
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:03
 * @Version 1.0
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TruckTraceDTO {

    private String truckNo;
    private BigDecimal angle;
    private BigDecimal speed;
    private BigDecimal mileage;
    private BigDecimal height;
    private BigDecimal[] location;
    private String gpsTime;
    private String createTime;
    private String modifiedTime;


    public TruckTraceDTO(String angle, String speed, String mileage, String height, String lon, String lat, String gpsTime) {
        this.angle = new BigDecimal(angle);
        this.speed = ZJXLPositionUtils.speedFormat(speed);
        this.mileage = ZJXLPositionUtils.mileageFormat(mileage);
        this.height = new BigDecimal(height);
        this.location = ZJXLPositionUtils.WGS484Format(lon, lat);
        this.gpsTime = ZJXLPositionUtils.gpsTimeFormat(gpsTime);
    }
}
