package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsDao extends BaseDao<OrderGoodsMapper, OrderGoods, Integer> {
    Long getMaxOrderGoodsId(String type);

    Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo);

    Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNo(String orderGoodsNo);

    IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param);
}
