package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        CREATED(10, "已接单"),

        PAYING(20, "支付中"),

        GO_TO_SEND(30, "前往货源地"),
        ARRIVE_SEND(40, "到达货源地"),
        LOAD(50 , "装货成功"),
        GO_TO_RECEIVE(60, "前往目的地"),
        ARRIVE_RECEIVE(70 , "到达目的地"),
        UNLOAD(80, "收货待确认"),

        UNSETTLED(90, "待结算"),

        COMPLETE(100, "完成"),

        DRIVER_CANCEL(110, "司机取消"),
        PLATFORM_CANCEL(111, "平台取消"),

//
//        OWNER_CONFIRM(50, "货主确认车辆"),//货主确认车辆
//        OWNER_LOAD(51, "货主装车"),//货主装车
//        DRIVER_CONFIRM(52, "司机确认装车"),//司机确认装车
//        GO_TO_RECEIVE(53, "前往目的地"),//前往目的地
//        ARRIVE_RECEIVE(54 , "到达目的地"),//到达目的地
//
//
//        OWNER_CONFIRM_TRUCK(100, "货主确认车辆"),//货主确认收货
//        COMPENSATION_SCAN_CODE(99, "质检员扫码"),//质检员扫码
//        OWNER_CONFIRM_UNLOAD(101, "货主确认收货"),//货主确认收货
//        DRIVER_CONFIRM_UNLOAD(102, "司机确认收货"),//司机确认收货
//        DRIVER_COMPLETE_ORDER(103, "已交货"),//已交货
//
//        //运单取消规则的状态
//        CANCEL_CONSULT_ORDER(110, "协商中"),//取消协商中
//
//        PAYING(120, "支付中"),//支付中
//        LOAD_PAYING(121, "货主装车支付中"),//货主装车支付中
//        RECEIVE_PAYING(122, "确认收货支付中"),//确认收货支付中
//        CANCEL_CONSULT_PAYING(123, "取消协商支付中"),//取消协商支付中
//
//
//        EVALUATE(151, "评价完成"),
//
//        REFUSE_LOAD(200, "拒绝装车"),//拒绝装车
//        OWNER_CANCELED(210, "货主取消"),
//        DRIVER_CANCELED(211, "司机取消"),
//        SYSTEM_SERVICE_CANCELED(213, "系统取消"),
//        CUSTOMER_SERVICE_CANCELED(212, "客服取消"),
//
//
//        CONSULT(220, "收货协商中"),
//        CUSTOMER_SERVICE_HANDLED(221, "客服处理完毕"),
//        LOAD_CONSULT(222,"装货协商中"),
//
//        PAY_FAIL(230, "司机接单支付失败"),
//        LOAD_PAY_FAIL(231, "货主装车调整支付失败"),
//        RECEIVE_PAY_FAIL(232, "确认收货支付失败"),
//        CANCEL_CONSULT_PAY_FAIL(233, "取消协商支付失败")//取消协商支付失败

        ;

        private final int code;
        private final String name;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }


}
