package com.clx.order.params;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Getter
@Setter
public class OrderGoodsChildParams {


    @ApiModelProperty("挂单运费")
    private BigDecimal pendingOrderFreight;

    @ApiModelProperty("提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;


    @ApiModelProperty("需要车辆/辆")
    private Integer needTruckNum;


    @ApiModelProperty("挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @ApiModelProperty(value = "最晚到达货源地时间/运单的最晚装货时间", example = "2023-09-09 12:00:01", required = true)
    private String lastArriveSendTime;

    @ApiModelProperty(value = "挂单时间", example = "2023-09-09 12:00:01", required = true)
    private String pendingOrderTime;


    @ApiModelProperty("高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @ApiModelProperty("高级物流经理姓名")
    private String seniorLogisticsManagerName;


    @ApiModelProperty(value = "定向运单失效时间", example = "2023-09-09 12:00:01", required = true)
    private String directionalExpireTime;

    @ApiModelProperty("创建人用户编号")
    private Long userNo;

    @ApiModelProperty("创建人姓名")
    private String userName;
}
