package com.clx.performance.extranal.broker.impl;

import com.clx.performance.config.SettlementConfig;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.extranal.broker.BrokerService;
import com.clx.performance.feign.BrokerFeign;
import com.clx.performance.vo.pc.broker.TransportParam;
import com.clx.performance.vo.pc.broker.TransportVO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class BrokerServiceImpl implements BrokerService {
    @Autowired
    public BrokerFeign brokerFeign;
    @Autowired
    private SettlementConfig settlementConfig;
    @Override
    public void orderChildSync(TransportParam param) {

        param.setUserCode(settlementConfig.getBrokerUserCode());

        Result<Object> result = brokerFeign.saveTransport(param);
        if (result.getCode() != 0) {
            log.info("运单同步网络货运失败, msg:{}", result.getMsg());
            throw new ServiceSystemException(ResultEnum.FEIGN_ERROR, result.getMsg());
        }
    }
    @Override
    public TransportVO getOrderChildStatus(String childNo) {

        Result<TransportVO> result = brokerFeign.getTransportByChildNo(childNo, settlementConfig.getBrokerUserCode());
        if (result.getCode() != 0) {
            log.info("运单同步网络货运失败, msg:{}", result.getMsg());
        }

        return result.getData();
    }

}
