package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


public enum SettlementOwnerDetailEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum InvoiceStatus {
        NO(0, "否"),
        YES(1, "是"),
        NO_INVOICE(2,"无需开票"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceStatus::getMsg).orElse(null);
        }
    }


    @Getter
    @AllArgsConstructor
    public enum FinalPaymentStatus {
        NO(0, "否"),
        YES(1, "是"),
        NO_REQUIRE(2,"无需支付")
        ;
        private final Integer code;
        private final String msg;

        public static Optional<FinalPaymentStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(FinalPaymentStatus::getMsg).orElse(null);
        }
    }
    @Getter
    @AllArgsConstructor
    public enum InvoiceChannel {
        BROKER(1, "无车承运"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceChannel> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceChannel::getMsg).orElse(null);
        }
    }


}
