package com.clx.performance.service.impl.trace;

import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.esplus.mapper.TruckLastPosESPlusMapper;
import com.clx.performance.esplus.mapper.TruckTraceESPlusMapper;
import com.clx.performance.esplus.model.TruckLatestPosESPlus;
import com.clx.performance.esplus.model.TruckTraceESPlus;
import com.clx.performance.param.mq.trace.TruckTraceSyncMqParam;
import com.clx.performance.service.trace.TruckTraceMqHandlerService;
import com.clx.performance.struct.trace.TruckTraceStruct;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.zjxl.ZjxlGpsService;
import lombok.extern.slf4j.Slf4j;
import org.dromara.easyes.core.conditions.select.LambdaEsQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class TruckTraceMqHandlerServiceImpl implements TruckTraceMqHandlerService {
    @Autowired
    private ZjxlGpsService zjxlGpsService;

    @Autowired
    private VehicleWarnChildDao vehicleWarnChildDao;

    @Autowired
    private TruckTraceESPlusMapper truckTraceESPlusMapper;

    @Autowired
    TruckLastPosESPlusMapper truckLastPosESPlusMapper;

    @Autowired
    TruckTraceStruct truckTraceStruct;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void truckTracSync(TruckTraceSyncMqParam mq) {

        List<TruckTraceDTO> list = zjxlGpsService.getTruckTrace(mq.getTruckNo(), mq.getBeginTime(), mq.getEndTime());
        if (list.isEmpty()) {return;}

        List<TruckTraceESPlus> esList = new ArrayList<>();
        for (TruckTraceDTO item : list) {
            TruckTraceESPlus es = new TruckTraceESPlus();
            es.setTruckNo(mq.getTruckNo());
            es.setAngle(item.getAngle());
            es.setHeight(item.getHeight());
            es.setLocation(new BigDecimal[]{item.getLocation()[0], item.getLocation()[1]});
            es.setGpsTime(item.getGpsTime());
            es.setMileage(item.getMileage());
            es.setSpeed(item.getSpeed());
            es.setCreateTime(LocalDateTimeUtils.formatTime());

            esList.add(es);
        }

        // 保存
        truckTraceESPlusMapper.insertBatch(esList);

        log.info("开始获取车辆的最新位置插入到es索引中=====================");

        //保存车辆最新的位置信息
        TruckTraceESPlus trace = esList.get(esList.size() - 1);
        TruckLatestPosESPlus truckLatestPos = truckLastPosESPlusMapper.selectOne(
                new LambdaEsQueryWrapper<TruckLatestPosESPlus>().eq(TruckLatestPosESPlus::getTruckNo, trace.getTruckNo()));
        log.info("通过车牌号：{}，查询车辆最新位置信息:{}",trace.getTruckNo(),truckLatestPos);
        TruckLatestPosESPlus item = truckTraceStruct.convert2LatestPos(trace);
        if(Objects.nonNull(truckLatestPos)){
            truckLastPosESPlusMapper.update(item,new LambdaEsQueryWrapper<TruckLatestPosESPlus>().
                    eq(TruckLatestPosESPlus::getTruckNo, trace.getTruckNo()));
        }else{
            truckLastPosESPlusMapper.insert(item);
        }
    }

}
