package com.clx.performance.feign;

import com.clx.performance.dto.payment.WalletResidueCardDTO;
import com.msl.common.result.Result;
import jakarta.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(name = "payment-service", path = "/payment-service")
public interface FeignPaymentService {

    /**
     * 获取钱包信息
     *
     * @param wallet
     * @return
     */
    @GetMapping(value = "/walletCard/getWallet")
    Result<WalletResidueCardDTO> getWallet(@RequestParam("userCode") @NotNull(message = "用户钱包地址编号不可为空") Integer userCode);

}
