package com.clx.performance.feign;

import com.msl.common.result.Result;
import jakarta.validation.constraints.NotBlank;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "order-service")
public interface FeignOrderService {


    @GetMapping(value = "/order-service/feign/getGoingOrderChildByTruckNo")
    Result<Integer> getGoingOrderChildByTruckNo (@RequestParam("truckNo") @NotBlank(message = "车牌号不能为空") String truckNo);

}
