package com.clx.performance.controller.temp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clx.performance.service.TempService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import com.nbopen.api.*;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/yftbank")
public class TempYftBankController {

    @Autowired
    private TempService tempService;

    @Operation(summary = "test", description = "<br>By:艾庆国")
    @RequestMapping(value = "/test", method = RequestMethod.POST)
    public Result<OrderChildLineStatisticsVO> test() throws Exception {

        bankTest();
        return Result.ok();
    }

    @Operation(summary = "test1", description = "<br>By:艾庆国")
    @RequestMapping(value = "/test1", method = RequestMethod.POST)
    public Result<OrderChildLineStatisticsVO> test1() throws Exception {

        bankTest1();
        return Result.ok();
    }

    @Operation(summary = "queryOrder", description = "<br>By:艾庆国")
    @RequestMapping(value = "/queryOrderTest", method = RequestMethod.POST)
    public Result queryOrderTest(String merSeqNo) throws Exception {

        queryOrder(merSeqNo);
        return Result.ok();
    }


    /**
     * 订单支付模式
     */
    public static void bankTest() throws Exception {
//        ClassPathResource classPathResource = new ClassPathResource("bank/config-nbbank.json");
//        InputStream inputStream = null;
//        try {
//            inputStream = classPathResource.getInputStream();
//            boolean initResult = NBOpenSDK.init(inputStream);
//            log.info("NBSDK初始化状态:{}", initResult);
//            log.info("sdk版本信息:{}", NBOpenSDK.getVersionInfo());
//        } catch (IOException e) {
//            e.printStackTrace();
//        }

        unionPayDirectOrder();
    }

    /**
     * 订单支付收款模式
     * 商户号：EFT33021200556315
     * 银行转账：86041110000075918（户名：客户客户）
     * 订单支付：结算账号（86041110000075926（户名：客户客户））
     * 86041110000076809:黑玫瑰
     * 响应结果：
     * {
     *     "data": {
     *         "errorCode": "000000",
     *         "errorMsg": "成功",
     *         "frontUrl": "",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231129133913",
     *         "signData": "",
     *         "transSeqNo": "2023112913391406547689VYvNioNz"
     *     },
     *     "head": {
     *         "rqsJrnlNo": "14414965925389704",
     *         "rspCode": "000000",
     *         "rspDate": "2023-11-29",
     *         "rspMsg": "交易成功",
     *         "rspTime": "13:39:16:035"
     *     }
     * }
     */
    private static void unionPayDirectOrder() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transId", "IP01");      //交易识别码 必填
            jsonObject.put("merId", "EFT33021200556315");     //商户号 必填

            jsonObject.put("merSeqNo", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));     //商户流水 必填
            jsonObject.put("merDtTm", LocalDateTimeUtils.formatTime());     //商户时间 必填

            jsonObject.put("trxAmt", "0.01");     //订单金额 必填
            jsonObject.put("orderDesc", "采购");     //订单详情 必填
            jsonObject.put("productName", "小黄鱼");     //商品名称 必填
            jsonObject.put("productId", "001");     //商品编号 必填
            jsonObject.put("productNum", "1");     //商品数量 必填

            jsonObject.put("payAcctNo", "86041110000076809");     //付款账号 必填
            jsonObject.put("payAcctNm", "黑玫瑰");     //付款户名 必填
            jsonObject.put("bankType", "00");     //账户类型 必填
            jsonObject.put("payAcctOpenBankId", "313332082914");     //开户行号 必填
//        jsonObject.put("mobilePhone", "13000000000");     //手机号

            HashMap<String,String> httpHeader = new HashMap<>();


            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("YFT");
            requestApiData.setServiceId("unionPayDirectOrder");
            requestApiData.setHttpHeader(httpHeader);

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            log.info("SDK请求内容unionPayDirectOrder: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            log.info("SDK响应结果unionPayDirectOrder: "+JSON.toJSONString(result));

//            queryOrder(JSON.parseObject(JSON.toJSONString(result)).getJSONObject("data").getString("merSeqNo"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 结果查询
     * 商户号：EFT33021200556315
     * 返回结果： 90:交易不存在
     * {
     *     "data": {
     *         "chargesAmt": "",
     *         "chargesType": "",
     *         "clearDate": "",
     *         "errorCode": "000000",
     *         "errorMsg": "成功",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231129135754",
     *         "payeeAcctBankName": "",
     *         "payeeAcctBankNo": "",
     *         "payeeAcctName": "",
     *         "payeeAcctNo": "",
     *         "payMethod": "",
     *         "pyerInfList": [
     *             {
     *                 "customerId": "",
     *                 "pyerAcctBankName": "",
     *                 "pyerAcctName": "",
     *                 "pyerAcctNo": "",
     *                 "signNo": "",
     *                 "transAmt": "",
     *                 "transDtTm": ""
     *             }
     *         ],
     *         "realTrxAmt": "",
     *         "transSeqNo": "",
     *         "transStatus": "90",
     *         "trxAmt": ""
     *     },
     *     "head": {
     *         "rqsJrnlNo": "15541586367762936",
     *         "rspCode": "000000",
     *         "rspDate": "2023-11-29",
     *         "rspMsg": "交易成功",
     *         "rspTime": "13:57:54:343"
     *     }
     * }
     * 返回结果： 02:交易已受理
     * {
     *     "data": {
     *         "chargesAmt": "",
     *         "chargesType": "",
     *         "clearDate": "20231129",
     *         "errorCode": "000000",
     *         "errorMsg": "成功",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231129142845",
     *         "payeeAcctBankName": "宁波银行股份有限公司",
     *         "payeeAcctBankNo": "313332082914",
     *         "payeeAcctName": "客户客户",
     *         "payeeAcctNo": "860411100000759182976409",
     *         "payMethod": "4",
     *         "pyerInfList": [
     *             {
     *                 "customerId": "",
     *                 "pyerAcctBankName": "",
     *                 "pyerAcctName": "",
     *                 "pyerAcctNo": "",
     *                 "signNo": "",
     *                 "transAmt": "",
     *                 "transDtTm": ""
     *             }
     *         ],
     *         "realTrxAmt": "0",
     *         "transSeqNo": "20231129142846065496766yDTQtg2",
     *         "transStatus": "02",
     *         "trxAmt": "1.23"
     *     },
     *     "head": {
     *         "rqsJrnlNo": "15543431902274569",
     *         "rspCode": "000000",
     *         "rspDate": "2023-11-29",
     *         "rspMsg": "交易成功",
     *         "rspTime": "14:28:51:431"
     *     }
     * }
     *
     * transStatus:
     * 00:交易成功
     * 01:交易失败
     * 02:交易已受理
     * 80:订单初始状态
     * 90:交易不存在
     * 99:交易超时,须发起交易结果查询
     */
    private static void queryOrder(String merSeqNo) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transId", "IP01");      //交易识别码 必填
            jsonObject.put("merId", "EFT33021200556315");     //商户号 必填

            jsonObject.put("merSeqNo", merSeqNo);     //商户流水 必填


            HashMap<String,String> httpHeader = new HashMap<>();


            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("YFT");
            requestApiData.setServiceId("queryOrder");
            requestApiData.setHttpHeader(httpHeader);

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            log.info("SDK请求内容queryOrder: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            log.info("SDK响应结果queryOrder: "+JSON.toJSONString(result));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 转账直连下单
     */
    public static void bankTest1() throws Exception {
//        ClassPathResource classPathResource = new ClassPathResource("bank/config-nbbank.json");
//        InputStream inputStream = null;
//        try {
//            inputStream = classPathResource.getInputStream();
//            boolean initResult = NBOpenSDK.init(inputStream);
//            log.info("NBSDK初始化状态:{}", initResult);
//            log.info("sdk版本信息:{}", NBOpenSDK.getVersionInfo());
//        } catch (IOException e) {
//            e.printStackTrace();
//        }

        directBankTransferOrder();
    }



    /**
     * 下单
     * 商户号：EFT33021200556315
     * 银行转账：86041110000075918（户名：客户客户）
     * 订单支付：结算账号（86041110000075926（户名：客户客户））
     * 响应结果：
     *{
     *     "data": {
     *         "acctNm": "客户客户",
     *         "acctOpenBankNm": "宁波银行股份有限公司",
     *         "bankId": "313332082914",
     *         "cardNo": "86041110000075918",
     *         "errorCode": "000000",
     *         "errorMsg": "成功",
     *         "signNo": "2976409",
     *         "transSeqNo": "20231129142846065496766yDTQtg2",
     *         "virtualDays": "2024-05-26"
     *     },
     *     "head": {
     *         "rqsJrnlNo": "15543427719351510",
     *         "rspCode": "000000",
     *         "rspDate": "2023-11-29",
     *         "rspMsg": "交易成功",
     *         "rspTime": "14:28:49:600"
     *     }
     * }
     */
    private static void directBankTransferOrder() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transId", "IP01");      //交易识别码 必填
            jsonObject.put("merId", "EFT33021200556315");     //商户号 必填

            jsonObject.put("merSeqNo", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));     //商户流水 必填
            jsonObject.put("merDtTm", LocalDateTimeUtils.formatTime());     //商户时间 必填

            jsonObject.put("trxAmt", "1.23");     //订单金额 必填
            jsonObject.put("orderDesc", "采购");     //订单详情 必填
            jsonObject.put("productName", "小黄鱼");     //商品名称 必填
            jsonObject.put("productId", "001");     //商品编号 必填
            jsonObject.put("productNum", "1");     //商品数量 必填


//            jsonObject.put("closeDtTm", "2023-11-29 13:39:16");     //关单时间
//            jsonObject.put("mobilePhone", "13000000000");     //手机号

            HashMap<String,String> httpHeader = new HashMap<>();


            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("YFT");
            requestApiData.setServiceId("directBankTransferOrder");
            requestApiData.setHttpHeader(httpHeader);

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            log.info("SDK请求内容directBankTransferOrder: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            log.info("SDK响应结果directBankTransferOrder: "+JSON.toJSONString(result));

//            queryOrder(jsonObject.getString("merSeqNo"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 结果查询
     * 商户号：EFT33021200556315
     * 返回结果：
     * {
     *     "data": {
     *         "chargesAmt": "",
     *         "chargesType": "",
     *         "clearDate": "",
     *         "errorCode": "000000",
     *         "errorMsg": "成功",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231129135754",
     *         "payeeAcctBankName": "",
     *         "payeeAcctBankNo": "",
     *         "payeeAcctName": "",
     *         "payeeAcctNo": "",
     *         "payMethod": "",
     *         "pyerInfList": [
     *             {
     *                 "customerId": "",
     *                 "pyerAcctBankName": "",
     *                 "pyerAcctName": "",
     *                 "pyerAcctNo": "",
     *                 "signNo": "",
     *                 "transAmt": "",
     *                 "transDtTm": ""
     *             }
     *         ],
     *         "realTrxAmt": "",
     *         "transSeqNo": "",
     *         "transStatus": "90",
     *         "trxAmt": ""
     *     },
     *     "head": {
     *         "rqsJrnlNo": "15541586367762936",
     *         "rspCode": "000000",
     *         "rspDate": "2023-11-29",
     *         "rspMsg": "交易成功",
     *         "rspTime": "13:57:54:343"
     *     }
     * }
     * transStatus:
     * 00:交易成功
     * 01:交易失败
     * 02:交易已受理
     * 80:订单初始状态
     * 90:交易不存在
     * 99:交易超时,须发起交易结果查询
     */
    private static void queryOrder1(String merSeqNo) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transId", "IP01");      //交易识别码 必填
            jsonObject.put("merId", "EFT33021200556315");     //商户号 必填

            jsonObject.put("merSeqNo", merSeqNo);     //商户流水 必填


            HashMap<String,String> httpHeader = new HashMap<>();


            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("YFT");
            requestApiData.setServiceId("queryOrder");
            requestApiData.setHttpHeader(httpHeader);

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            log.info("SDK请求内容queryOrder: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            log.info("SDK响应结果queryOrder: "+JSON.toJSONString(result));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    private static void testAPI1() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("qryType","3");
            jsonObject.put("idNo","330125197810053747");
            jsonObject.put("idType","1");
            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("");
            requestApiData.setServiceId("commontest");

            HashMap<String,String> httpHeader = new HashMap<>();
            requestApiData.setHttpHeader(httpHeader);

            SDKRequest request = new SDKRequest();
            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());
            request.setHead(requestHead);
            request.setData(requestApiData);

            System.out.println("SDK请求内容: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            System.out.println("SDK响应结果: "+JSON.toJSONString(result));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//
//    //文件上传测试接口
//    private static void testUploadFile(String localFileName,String remoteFileName,String tranCode) throws Exception {
//        try{
//            SDKRequest request = new SDKRequest();
//            RequestHead head = new RequestHead();
//            head.setRqsJrnlNo(NBOpenSDK.getRandom());
//            request.setHead(head);
//            RequestFileData fileData = new RequestFileData();
//            fileData.setLocalFilePath("C:\\Users\\k6118\\Downloads\\11.json");
//            fileData.setRemoteFileName("11.json");
//            fileData.setTranCode("merFileUploadApply");
//            fileData.setUid("YITANG");
//            request.setData(fileData);
//            System.out.println("---SDK请求报文: "+ JSON.toJSONString(request, SerializerFeature.WriteMapNullValue));
//            SDKResponse response = NBOpenSDK.putFile(request);
//            System.out.println( "---SDK响应结果: "+ JSON.toJSONString(response,SerializerFeature.WriteMapNullValue));
//        } catch (Exception e){
//            e.printStackTrace();
//        }
//    }
//
//    //文件下载测试接口
//    private static void testDownloadFile(String localFileName,String remoteFileName,String tranCode) throws Exception {
//        try{
//            SDKRequest request = new SDKRequest();
//            RequestHead head = new RequestHead();
//            head.setRqsJrnlNo(NBOpenSDK.getRandom());
//            request.setHead(head);
//            RequestFileData fileData = new RequestFileData();
//            fileData.setLocalFilePath("C:\\Users\\k6118\\Downloads\\12.json");
//            fileData.setRemoteFileName("8374eb1718cf4083a74430ebd9af058f/11.json");
//            fileData.setTranCode("merFileDownloadApply");
//            fileData.setUid("YITANG");
//            request.setData(fileData);
//            System.out.println("---SDK请求报文: "+ JSON.toJSONString(request, SerializerFeature.WriteMapNullValue));
//            SDKResponse response = NBOpenSDK.getFile(request);
//            System.out.println( "---SDK响应结果: "+ JSON.toJSONString(response,SerializerFeature.WriteMapNullValue));
//        } catch (Exception e){
//            e.printStackTrace();
//        }
//    }
//
//    /**
//     * 易付通
//     */
//    static String unionPayDirectOrder() throws Exception {
//
//        HashMap<String, Object> map = new HashMap();
//        HashMap<String, Object> data = new HashMap();
//        map.put("Data", data);
//
//        data.put("transId", "IP01");      //交易识别码 必填
//        data.put("merId", "2023112300000002");     //商户号 必填
//        data.put("merSeqNo", "2023112300000001");     //商户流水 必填
//        data.put("merDtTm", "2023-11-24 11:00:00");     //商户时间 必填
//        data.put("trxAmt", "1.23");     //订单金额 必填
//        data.put("orderDesc", "采购");     //订单详情 必填
//        data.put("productNam", "小黄鱼");     //商品名称 必填
//        data.put("productId", "001");     //商品编号 必填
//        data.put("productNum", "1");     //商品数量 必填
//
//        data.put("payAcctNo", "6223161100110442");     //付款账号 必填
//        data.put("payAcctNm", "刘晓琴");     //付款户名 必填
//        data.put("bankType", "00");     //账户类型 必填
//        data.put("payAcctOpenBankId", "313332082914");     //开户行号 必填
////        data.put("mobilePhone", "13000000000");     //手机号
//
//        String res1 = NBOpenSDK.send("YFT", "unionPayDirectOrder", JSON.toJSONString(map));
//        log.info("银联订单支付收款模式接口：{}" , res1);
//
//        return res1;
//    }
//
//
    public static void main(String[] args) throws Exception {

        bankTest();

    }


}
