package com.clx.performance.controller.feign;

import com.clx.performance.param.pc.IntegralTruckAddParam;
import com.clx.performance.service.IntegralTruckService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/feign/integral")
@Validated
@Tag(name = "积分车辆")
public class IntegralTruckFeignController {

    @Autowired
    private IntegralTruckService integralTruckService;

    @Operation(summary = "新增车辆")
    @PostMapping("/saveTruck")
    Result<Void> saveTruck(@RequestBody @Validated IntegralTruckAddParam param){
        integralTruckService.saveTruck(param);

        return Result.ok();
    }

}
