package com.clx.performance.sqlProvider;

import cn.hutool.core.util.ObjectUtil;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.param.pc.PageOwnerAccountRunningWaterParam;
import com.clx.performance.param.pc.PagePlatformMarginAccountParam;
import com.clx.performance.param.pc.PagePlatformPrepaidFreightAccountParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OwnerRunningWaterRecordSqlProvider {

    public String marginAccountPageList(@Param("param") PagePlatformMarginAccountParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name,a.running_water_no, a.mobile, a.account_type, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance, a.frozen_balance,a.take_out_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.account_type =" + OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode());
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }
            if (StringUtils.isNotBlank(param.getRunningWaterNo())) {
                WHERE("a.running_water_no = #{param.runningWaterNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String marginAccountList(@Param("param") PagePlatformMarginAccountParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name,a.running_water_no, a.mobile, a.account_type, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance, a.frozen_balance,a.take_out_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.account_type =" + OwnerAccountEnum.AccountTypeStatus.MARGIN_ACCOUNT.getCode());
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }
            if (StringUtils.isNotBlank(param.getRunningWaterNo())) {
                WHERE("a.running_water_no = #{param.runningWaterNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }


    public String prepaidFreightAccountPageList(@Param("param") PagePlatformPrepaidFreightAccountParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name,a.running_water_no, a.mobile, a.account_type, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance,a.take_out_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.account_type =" + OwnerAccountEnum.AccountTypeStatus.PREPAID_FREIGHT_ACCOUNT.getCode());
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }
            if (StringUtils.isNotBlank(param.getOrderNo())) {
                WHERE("a.order_no = #{param.orderNo}");
            }
            if (StringUtils.isNotBlank(param.getOrderChildNo())) {
                WHERE("a.order_child_no = #{param.orderChildNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String prepaidFreightAccountList(@Param("param") PagePlatformPrepaidFreightAccountParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name,a.running_water_no, a.mobile, a.account_type, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance,a.take_out_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.account_type =" + OwnerAccountEnum.AccountTypeStatus.PREPAID_FREIGHT_ACCOUNT.getCode());
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }
            if (StringUtils.isNotBlank(param.getOrderNo())) {
                WHERE("a.order_no = #{param.orderNo}");
            }
            if (StringUtils.isNotBlank(param.getOrderChildNo())) {
                WHERE("a.order_child_no = #{param.orderChildNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }


    public String ownerAccountRunningWaterPageList(@Param("param") PageOwnerAccountRunningWaterParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type,a.running_water_no, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance,a.take_out_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }

            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String ownerAccountRunningWaterList(@Param("param") PageOwnerAccountRunningWaterParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type, a.running_water_type,a.order_id,a.order_no,a.order_child_id,a.order_child_no,a.alteration_balance," +
                    " a.account_balance,a.usable_balance,a.take_out_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_running_water_record a");
            WHERE("a.owner_user_no = #{param.ownerUserNo}");

            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }

            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }


}
