package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.IntegralNextWeekTruckInitMqParam;
import com.clx.performance.service.IntegralMqHandlerService;
import com.clx.performance.common.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 积分车辆新增 mq
 * @Date: 2023-10-12 11:44:13
 * @Version: 1.0
 */
@Slf4j
@Component
public class IntegralNextWeekTruckInitListener {

    @Autowired
    private IntegralMqHandlerService integralMqHandlerService;

    @RabbitListener(queues = RabbitKeyIntegralConstants.INTEGRAL_NEXT_WEEK_TRUCK_INIT_QUEUE)
    public void process(Message message) {
        try{
            log.info("司机积分-下周车辆初始化, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<IntegralNextWeekTruckInitMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("司机积分-下周车辆初始化 失败",e);
        }
    }

    private void process(IntegralNextWeekTruckInitMqParam mq){

        integralMqHandlerService.nextWeekTruckInit(mq);

    }
}
