package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
public class NetworkCaseOutRecordVO {

    private Integer id;

    @ApiModelProperty("提现单号")
    private Long caseOutNo;

    @ApiModelProperty("司机编码")
    private String driverUserNo;

    @ApiModelProperty("司机名称")
    private String driverUserName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("收款人")
    private String payee;

    @ApiModelProperty("开户行")
    private String bank;

    @ApiModelProperty("收款银行账户")
    private String collectionBankCode;

    @ApiModelProperty("状态 10：待平台付款 20：已付款")
    private Integer status;

    @ApiModelProperty("状态简介")
    private String statusMsg;

    @ApiModelProperty("平台")
    private String platform;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("运单编号")
    private String childNo;

    @ApiModelProperty("变动金额")
    private BigDecimal alterationBalance;

    @ApiModelProperty("操作人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("提现完成时间")
    private String finishTime;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
