package com.clx.performance.struct.settle;

import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.carrier.settle.SettlementMergeVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {SettlementOwnerEnum.class, DateUtils.class})
public interface SettlementOwnerStruct {

    @Mapping(target = "invoiceTypeCode", source = "invoiceType")
    @Mapping(target = "invoiceTypeMsg", expression = "java(SettlementOwnerEnum.InvoiceType.getMsgByCode(settlementOwner.getInvoiceType()))")
    @Mapping(target = "invoiceStatusCode", source = "invoiceStatus")
    @Mapping(target = "invoiceStatusMsg", expression = "java(SettlementOwnerEnum.InvoiceStatus.getMsgByCode(settlementOwner.getInvoiceStatus()))")
    @Mapping(target = "statusCode", source = "status")
    @Mapping(target = "statusMsg", expression = "java(SettlementOwnerEnum.Status.getMsgByCode(settlementOwner.getStatus()))")
    CarrierSettlementOwnerDetailVO convertToDetail(SettlementOwner settlementOwner);


    List<SettlementMergeVO> convertToMergeList(List<SettlementOwner> settlementOwners);

    List<CarrierPageSettlementOwnerVO> convertList(List<SettlementOwner> settlementOwners);



}