package com.clx.performance.struct.settle;

import com.clx.performance.enums.settle.SettlementOwnerDetailEnum;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {SettlementOwnerDetailEnum.class, SettlementOwnerEnum.class,DateUtils.class})
public interface SettlementOwnerDetailStruct {


    List<CarrierPageSettlementOwnerDetailVO> covertList(List<SettlementOwnerDetail> list);



    @Named("toBaseVo")
    @Mapping(target = "invoiceTypeMsg", expression = "java(SettlementOwnerEnum.InvoiceType.getMsgByCode(settlementOwner.getInvoiceType()))")
    @Mapping(target = "finalPaymentStatusMsg", expression = "java(SettlementOwnerDetailEnum.FinalPaymentStatus.getMsgByCode(settlementOwner.getInvoiceStatus()))")
    @Mapping(target = "invoiceStatusMsg", expression = "java(SettlementOwnerDetailEnum.InvoiceStatus.getMsgByCode(settlementOwner.getStatus()))")
    PageOwnerSettlementOwnerDetailVO convert(SettlementOwnerDetail settlementOwner);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageOwnerSettlementOwnerDetailVO> covertToOwnerList(List<SettlementOwnerDetail> list);
}