package com.clx.performance.sqlProvider;

import cn.hutool.core.util.ObjectUtil;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OwnerAccountSqlProvider {

    public String pageList(@Param("param") PageOwnerAccountListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type, " +
                    " a.account_balance,a.usable_balance, a.frozen_balance,a.create_by,a.create_time");
            FROM("owner_account a");


            if (StringUtils.isNotBlank(param.getOwnerCode())) {
                WHERE("a.owner_code = #{param.ownerCode}");
            }
            if (ObjectUtil.isNotNull(param.getMobile())) {
                WHERE("a.mobile = #{param.mobile}");
            }
            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

}
