package com.clx.performance.service.impl.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OwnerBindCardRecordDao;
import com.clx.performance.dao.settle.SettlementLogDao;
import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.dao.settle.SettlementPlatformAccountDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.model.OwnerBindCardRecord;
import com.clx.performance.model.settle.SettlementLog;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.model.settle.SettlementPlatformAccount;
import com.clx.performance.param.pc.owner.OwnerPaymentSettlementParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.struct.settle.SettlementLogStruct;
import com.clx.performance.struct.settle.SettlementOwnerStruct;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.carrier.settle.SettlementLogVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Slf4j
@Service
@AllArgsConstructor
public class SettlementOwnerServiceImpl  implements SettlementOwnerService {

    private final SettlementOwnerDao settlementOwnerDao;

    private final SettlementOwnerStruct settlementOwnerStruct;

    private final SettlementLogDao settlementLogDao;

    private final SettlementLogStruct settlementLogStruct;

    private final SettlementPlatformAccountDao settlementPlatformAccountDao;

    private final OwnerBindCardRecordDao ownerBindCardRecordDao;


    @Override
    public CarrierSettlementOwnerDetailVO getCarrierSettlementOwnerDetail(Integer id) {
        //结算单详情
        SettlementOwner settlementOwner =settlementOwnerDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        CarrierSettlementOwnerDetailVO detail = settlementOwnerStruct.convertToDetail(settlementOwner);

        String settlementNo = settlementOwner.getSettlementNo();
        //合并结算单
        List<SettlementOwner> mergeSettlementNos = settlementOwnerDao.getMergeSettlementNos(settlementNo);
        detail.setMergers(settlementOwnerStruct.convertToMergeList(mergeSettlementNos));

        //操作日志
        List<SettlementLog> settlementLogs = settlementLogDao.getSettlementLogs(settlementNo);
        List<SettlementLogVO> settlementLogVOS = settlementLogStruct.convert(settlementLogs);
        detail.setSettlementLogs(settlementLogVOS);
        return detail;

    }

    @Override
    public void updateConfirmSettlement(Integer id) {
        //结算单详情
        SettlementOwner settlementOwner =settlementOwnerDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        //状态判断
        if(!Objects.equals(settlementOwner.getStatus(), SettlementOwnerEnum.Status.OWNER_TO_BE_CONFIRMED.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.SETTLEMENT_ORDER_STATUS_CHANGED);
        }
        //更新状态为待货主付款
        settlementOwnerDao.updateStatusBySettlementNo(settlementOwner.getSettlementNo(),SettlementOwnerEnum.Status.SHIPPER_TO_PAYMENT.getCode());
    }

    @Override
    public SettlementPlatformAccountVO getSettlementPlatformAccount() {
        //平台账号
        SettlementPlatformAccount platformAccount = settlementPlatformAccountDao.getSettlementPlatformAccount();
        //返回对象
        SettlementPlatformAccountVO vo = new SettlementPlatformAccountVO();
        if(Objects.nonNull(platformAccount)){
            vo.setPayee(platformAccount.getCardHolder());
            vo.setPayeeBankCardNo(platformAccount.getBankCardNo());
            vo.setPayeeBankName(platformAccount.getBankName());
        }

        //当前账号
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        OwnerBindCardRecord card = ownerBindCardRecordDao.getOwnerBindCardByUserNo(loginUserInfo.getUserNo());
        if(Objects.nonNull(card)){
            vo.setPaymentBankCardNo(card.getBankCardNumber());
            vo.setPaymentBankName(card.getAccountBankName());
        }
        return vo;
    }

    @Override
    public void updatePaymentSettlement(OwnerPaymentSettlementParam param) {
        //结算单详情
        SettlementOwner settlementOwner =settlementOwnerDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        //状态判断
        if(!Objects.equals(settlementOwner.getStatus(), SettlementOwnerEnum.Status.SHIPPER_TO_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.SETTLEMENT_ORDER_STATUS_CHANGED);
        }
        //更新状态为平台确认货主付款
        SettlementOwner settlement = SettlementOwner.builder().payee(param.getPayee()).payeeBankCardNo(param.getPayeeBankCardNo())
                .payeeBankName(param.getPayeeBankName()).paymentBankCardNo(param.getPaymentBankCardNo())
                .paymentBankName(param.getPaymentBankName()).paymentImg(param.getPaymentImg())
                .settlementNo(settlementOwner.getSettlementNo())
                .status(SettlementOwnerEnum.Status.PLATFORM_CONFIRMED_OWNER_PAYMENT.getCode()).build();
        settlementOwnerDao.updatePayment(settlement);
    }

    @Override
    public void updatePaymentConfirmSettlement(Integer id) {

        //结算单详情
        SettlementOwner settlementOwner =settlementOwnerDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        //状态判断
        if(!Objects.equals(settlementOwner.getStatus(), SettlementOwnerEnum.Status.OWNER_CONFIRMED_PLATFORM_PAYMENT.getCode())){
            throw new ServiceSystemException(PerformanceResultEnum.SETTLEMENT_ORDER_STATUS_CHANGED);
        }
        Integer status = SettlementOwnerEnum.Status.INVOICE_TO_BE_MAILED.getCode();//待邮寄发票
        if(Objects.equals(settlementOwner.getStatus(),SettlementOwnerEnum.InvoiceType.ONLINE.getCode())){//网运单
            status = SettlementOwnerEnum.Status.COMPLETED.getCode();
        }
        //更新状态
        settlementOwnerDao.updateStatusBySettlementNo(settlementOwner.getSettlementNo(),status);

    }

    @Override
    public IPage<CarrierPageSettlementOwnerVO> pageCarrierSettlementOwner(PageCarrierSettlementOwnerParam param) {
        IPage<SettlementOwner> page =  settlementOwnerDao.pageCarrierSettlementOwner(param);
        List<CarrierPageSettlementOwnerVO> list = settlementOwnerStruct.convertList(
                page.getRecords());
        IPage<CarrierPageSettlementOwnerVO> result = new Page().setRecords(list).setTotal(page.getTotal()).setPages(
                page.getPages());
        return result;
    }
}
