package com.clx.performance.service.impl.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.struct.settle.SettlementDriverDetailStruct;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverDetailVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Service
@Slf4j
@AllArgsConstructor
public class SettlementDriverDetailServiceImpl  implements SettlementDriverDetailService {

    private final SettlementDriverDetailDao settlementDriverDetailDao;
    private final SettlementDriverDetailStruct settlementOwnerDetailStruct;


    @Override
    public IPage<CarrierPageSettlementDriverDetailVO> pageSettlementDriverDetail(
            PageCarrierSettlementDriverDetailParam param) {
        IPage<SettlementDriverDetail> result = settlementDriverDetailDao.pageSettlementDriverDetail(param);
        List<CarrierPageSettlementDriverDetailVO> list = settlementOwnerDetailStruct.covertList(result.getRecords());
        return new Page<CarrierPageSettlementDriverDetailVO>().setRecords(list).setTotal(result.getTotal()).setPages(result.getPages());
    }
}
