package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.component.IdGenerateSnowFlake;
import com.clx.performance.dao.*;
import com.clx.performance.enums.IdTypeEnum;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.*;
import com.clx.performance.param.pc.*;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.user.enums.driver.DriverTruckEnum;
import com.clx.user.feign.OwnerInfoFeign;
import com.clx.user.param.pc.owner.UpdateOwnerBindCardFeignParam;
import com.clx.user.vo.pc.driver.truck.DriverTruckVo;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@AllArgsConstructor
public class OwnerAccountServiceImpl implements OwnerAccountService {

    private final OwnerAccountDao ownerAccountDao;

    private final OwnerRunningWaterRecordDao ownerRunningWaterRecordDao;

    private final IdGenerateSnowFlake idGenerateSnowFlake;

    private final OwnerTopUpDao ownerTopUpDao;

    private final OwnerCaseOutDao ownerCaseOutDao;

    private final OwnerTransferInfoDao ownerTransferInfoDao;

    private final OwnerInfoFeign ownerInfoFeign;

    private final OwnerBindCardRecordDao ownerBindCardRecordDao;

    @Override
    public IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param) {
        return ownerAccountDao.pageList(param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(PagePlatformMarginAccountParam param) {
        return ownerRunningWaterRecordDao.marginAccountPageList(param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param) {
        return ownerRunningWaterRecordDao.prepaidFreightAccountPageList(param);
    }

    @Override
    public List<OwnerAccountVO> accountInfo(Long ownerUserNo) {
        return ownerAccountDao.accountInfo(ownerUserNo);
    }

    @Override
    public Long accountTopUp(OwnerTopUpParam param) {
        OwnerTopUp entity = new OwnerTopUp();
        entity.setAccountType(param.getAccountType());
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setTopUpBalance(param.getTopUpBalance());
        entity.setStatus(OwnerAccountEnum.TopUpStatus.PENDING.getCode());
        entity.setDrawingBank(param.getDrawingBank());
        entity.setDrawingBankNumber(param.getDrawingBankNumber());
        entity.setDrawingProof(param.getDrawingProof());
        //充值编号
        entity.setTopUpNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.TOP_UP.getCode()));

        ownerTopUpDao.saveEntity(entity);
        return entity.getTopUpNo();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long accountCaseOut(OwnerCaseOutParam param) {
        //提现记录
        OwnerCaseOut entity = new OwnerCaseOut();
        entity.setAccountType(param.getAccountType());
        entity.setCaseOutNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT.getCode()));
        entity.setOwnerUserNo(param.getOwnerUserNo());
        entity.setCaseOutBalance(param.getCaseOutBalance());
        entity.setStatus(OwnerAccountEnum.CaseOutStatus.PENDING_PAYMENT.getCode());
        entity.setCaseOutBank(param.getCaseOutBank());
        entity.setCaseOutBankNumber(param.getCaseOutBankNumber());

        ownerCaseOutDao.saveEntity(entity);
        //插入冻结流水
        OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
        BigDecimal caseOutBalance = param.getCaseOutBalance();
        runningWaterRecord.setOwnerName("测试");
        runningWaterRecord.setMobile("11111111111");
        runningWaterRecord.setCreateBy("操作人测试");
        runningWaterRecord.setRelationId(entity.getCaseOutNo());
        runningWaterRecord.setAccountBalance(caseOutBalance);
        runningWaterRecord.setOwnerUserNo(param.getOwnerUserNo());
        runningWaterRecord.setAccountType(param.getAccountType());
        runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.FROZEN.getCode());
        runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT_FROZEN.getCode()));
        ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);
        //冻结账户可用金额
        OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(param.getOwnerUserNo(), param.getAccountType());
        OwnerAccount update = new OwnerAccount();
        update.setUsableBalance(account.getUsableBalance().subtract(caseOutBalance));
        update.setFrozenBalance(account.getFrozenBalance().add(caseOutBalance));
        update.setId(account.getId());
        ownerAccountDao.updateEntityByKey(update);

        return entity.getCaseOutNo();
    }

    /**
     * 充值审批
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void accountTopUpApprove(PlatformAccountTopUpParam param) {
        Optional<OwnerTopUp> optional = ownerTopUpDao.getEntityByKey(param.getId());
        if (!optional.isPresent()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前ID未查询到有效记录");
        }
        OwnerTopUp ownerTopUp = optional.get();
        OwnerTopUp entity = new OwnerTopUp();
        if (!param.getPassType()) {
            entity.setId(param.getId());
            entity.setApprovalTurnDown(param.getTurnDownContent());
            entity.setStatus(OwnerAccountEnum.TopUpStatus.APPROVAL_REJECTION.getCode());
            ownerTopUpDao.updateEntityByKey(entity);
        } else {
            entity.setId(param.getId());
            entity.setStatus(OwnerAccountEnum.TopUpStatus.APPROVAL_APPROVE.getCode());
            ownerTopUpDao.updateEntityByKey(entity);
            //需要插入充值流水
            OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
            BigDecimal topUpBalance = ownerTopUp.getTopUpBalance();
            runningWaterRecord.setOwnerName("测试");
            runningWaterRecord.setMobile("11111111111");
            runningWaterRecord.setCreateBy("操作人测试");

            runningWaterRecord.setRelationId(ownerTopUp.getTopUpNo());
            runningWaterRecord.setAccountBalance(topUpBalance);
            runningWaterRecord.setOwnerUserNo(param.getOwnerUserNo());

            runningWaterRecord.setAccountType(param.getAccountType());
            runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.TOP_UP.getCode());
            runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.TOP_UP_SUCCESS.getCode()));
            ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);
            //给对应账户增加金额

            OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(param.getOwnerUserNo(), param.getAccountType());
            OwnerAccount update = new OwnerAccount();
            update.setAccountBalance(account.getAccountBalance().add(topUpBalance));
            update.setUsableBalance(account.getUsableBalance().add(topUpBalance));
            update.setId(account.getId());
            ownerAccountDao.updateEntityByKey(update);
        }
    }

    /**
     * 提现审批
     *
     * @param param
     */
    @Override
    public void accountCaseOutApprove(OwnerCaseOutApproveParam param) {
        OwnerCaseOut entity = new OwnerCaseOut();
        entity.setId(param.getId());
        entity.setPaymentProof(param.getPaymentProof());
        entity.setPlatformPaymentBank(entity.getPlatformPaymentBank());
        entity.setPlatformPaymentBankNumber(param.getPlatformPaymentBankNumber());
        entity.setPlatformPayBalance(param.getPlatformPayBalance());
        entity.setStatus(OwnerAccountEnum.CaseOutStatus.TO_BE_CONFIRMED.getCode());
        ownerCaseOutDao.updateEntityByKey(entity);
    }

    @Override
    public void accountBalanceConfirm(Integer id) {
        Optional<OwnerCaseOut> optional = ownerCaseOutDao.getEntityByKey(id);
        if (!optional.isPresent()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前ID未查询到有效记录");
        }
        OwnerCaseOut ownerCaseOut = optional.get();
        BigDecimal caseOutBalance = ownerCaseOut.getCaseOutBalance();
        BigDecimal platformPayBalance = ownerCaseOut.getPlatformPayBalance();
        if (platformPayBalance.compareTo(caseOutBalance) != 0) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主提现金额和平台支付金额不一致");
        }
        //插入提现成功流水
        OwnerRunningWaterRecord runningWaterRecord = new OwnerRunningWaterRecord();
        runningWaterRecord.setOwnerName("测试");
        runningWaterRecord.setMobile("11111111111");
        runningWaterRecord.setCreateBy("操作人");

        runningWaterRecord.setRelationId(ownerCaseOut.getCaseOutNo());
        runningWaterRecord.setAccountBalance(caseOutBalance);
        runningWaterRecord.setOwnerUserNo(ownerCaseOut.getOwnerUserNo());

        runningWaterRecord.setAccountType(ownerCaseOut.getAccountType());
        runningWaterRecord.setRunningWaterType(OwnerAccountEnum.RunningWaterStatus.CASE_OUT_SUCCESS.getCode());
        runningWaterRecord.setRunningWaterNo(idGenerateSnowFlake.nextId(IdTypeEnum.Type.CASE_OUT_SUCCESS.getCode()));
        ownerRunningWaterRecordDao.saveEntity(runningWaterRecord);
        //给对应账户减少金额

        OwnerAccount account = ownerAccountDao.getAccountByOwnerUserNoAndAccountType(ownerCaseOut.getOwnerUserNo(), ownerCaseOut.getAccountType());
        OwnerAccount update = new OwnerAccount();
        update.setAccountBalance(account.getAccountBalance().subtract(caseOutBalance));
        update.setUsableBalance(account.getUsableBalance().subtract(caseOutBalance));
        update.setFrozenBalance(account.getFrozenBalance().subtract(caseOutBalance));
        update.setId(account.getId());
        ownerAccountDao.updateEntityByKey(update);
    }

    @Override
    public SXSSFWorkbook exportMarginAccountPageList(PagePlatformMarginAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerRunningWaterRecordDao.marginAccountPageList(param);
        List<OwnerAccountRunningWaterRecordVO> list = page.getRecords();
        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "货主编码", "ownerUserNo", 5000));
        fieldList.add(new ExcelField(2, "货主名称", "ownerName", 5000));
        fieldList.add(new ExcelField(3, "联系电话", "mobile", 5000));
        fieldList.add(new ExcelField(4, "账户类型", "accountType", 15000));
        fieldList.add(new ExcelField(5, "流水类型", "runningWaterType", 5000));
        fieldList.add(new ExcelField(6, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(7, "变动金额", "alterationBalance", 5000));
        fieldList.add(new ExcelField(8, "冻结金额", "frozenBalance", 5000));
        fieldList.add(new ExcelField(9, "可用余额", "usableBalance", 5000));
        fieldList.add(new ExcelField(10, "账户余额", "accountBalance", 5000));
        fieldList.add(new ExcelField(11, "扣除金额", "takeOutBalance", 5000));
        fieldList.add(new ExcelField(12, "流水编号", "runningWaterNo", 5000));
        fieldList.add(new ExcelField(13, "操作人", "createBy", 5000));
        fieldList.add(new ExcelField(14, "操作时间", "createTime", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {

            OwnerAccountRunningWaterRecordVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i + 1));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));
            rowData.add(new ExcelData(dto.getOwnerName()));
            rowData.add(new ExcelData(dto.getMobile()));
            rowData.add(new ExcelData(OwnerAccountEnum.AccountTypeStatus.getByCode(dto.getAccountType()).get().getMsg()));
            rowData.add(new ExcelData(OwnerAccountEnum.RunningWaterStatus.getByCode(dto.getRunningWaterType()).get().getMsg()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getAlterationBalance()));
            rowData.add(new ExcelData(dto.getFrozenBalance()));
            rowData.add(new ExcelData(dto.getUsableBalance()));
            rowData.add(new ExcelData(dto.getAccountBalance()));
            rowData.add(new ExcelData(dto.getTakeOutBalance()));
            rowData.add(new ExcelData(dto.getRunningWaterNo().toString()));
            rowData.add(new ExcelData(dto.getCreateBy()));
            rowData.add(new ExcelData(dto.getCreateTime().toString()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("保证金账户详情", "保证金账户详情", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }

    @Override
    public SXSSFWorkbook exportPrepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerRunningWaterRecordDao.prepaidFreightAccountPageList(param);
        List<OwnerAccountRunningWaterRecordVO> list = page.getRecords();
        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "货主编码", "ownerUserNo", 5000));
        fieldList.add(new ExcelField(2, "货主名称", "ownerName", 5000));
        fieldList.add(new ExcelField(3, "联系电话", "mobile", 5000));
        fieldList.add(new ExcelField(4, "账户类型", "accountType", 15000));
        fieldList.add(new ExcelField(5, "流水类型", "runningWaterType", 5000));
        fieldList.add(new ExcelField(6, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(7, "运单编号", "orderChildNo", 5000));

        fieldList.add(new ExcelField(8, "变动金额", "alterationBalance", 5000));
        fieldList.add(new ExcelField(9, "冻结金额", "frozenBalance", 5000));
        fieldList.add(new ExcelField(10, "可用余额", "usableBalance", 5000));
        fieldList.add(new ExcelField(11, "账户余额", "accountBalance", 5000));
        fieldList.add(new ExcelField(12, "扣除金额", "takeOutBalance", 5000));
        fieldList.add(new ExcelField(13, "流水编号", "runningWaterNo", 5000));
        fieldList.add(new ExcelField(14, "操作人", "createBy", 5000));
        fieldList.add(new ExcelField(15, "操作时间", "createTime", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {

            OwnerAccountRunningWaterRecordVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i + 1));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));
            rowData.add(new ExcelData(dto.getOwnerName()));
            rowData.add(new ExcelData(dto.getMobile()));
            rowData.add(new ExcelData(OwnerAccountEnum.AccountTypeStatus.getByCode(dto.getAccountType()).get().getMsg()));
            rowData.add(new ExcelData(OwnerAccountEnum.RunningWaterStatus.getByCode(dto.getRunningWaterType()).get().getMsg()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOrderChildNo()));
            rowData.add(new ExcelData(dto.getAlterationBalance()));
            rowData.add(new ExcelData(dto.getFrozenBalance()));
            rowData.add(new ExcelData(dto.getUsableBalance()));
            rowData.add(new ExcelData(dto.getAccountBalance()));
            rowData.add(new ExcelData(dto.getTakeOutBalance()));
            rowData.add(new ExcelData(dto.getRunningWaterNo().toString()));
            rowData.add(new ExcelData(dto.getCreateBy()));
            rowData.add(new ExcelData(dto.getCreateTime().toString()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("预付账户详情", "预付账户详情", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }

    @Override
    public OwnerTransferInfo transferPublic() {
        return ownerTransferInfoDao.getEntityByKey(1).orElse(null);
    }

    @Override
    public OwnerBindCardVO getOwnerBindCard(Long userNo) {
        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(userNo);
        if (result.succeed()) {
            return result.getData();
        } else {
            return null;
        }
    }

    @Override
    public void bindOwnerBindCard(UpdateOwnerBindCardFeignParam param) {
        Result<OwnerBindCardVO> result = ownerInfoFeign.getOwnerInfoVO(param.getUserNo());
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前参数未查询到有效数据");
        }
        if (result.succeed() && StringUtils.isNotBlank(result.getData().getOwnerAccountBank())) {
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前货主存在绑定银行卡,请先解绑银行卡后再进行绑定操作");
        }

        ownerInfoFeign.bindOwnerBindCard(param);
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        record.setOwnerType(param.getOwnerType());
        record.setOwnerUserNo(param.getUserNo());
        record.setCreateItem("绑定银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setCreateBy("曹做人");
        ownerBindCardRecordDao.saveEntity(record);
    }

    @Override
    public void unBindOwnerBindCard(UpdateOwnerBindCardFeignParam param) {
        OwnerBindCardRecord record = new OwnerBindCardRecord();
        record.setOwnerType(param.getOwnerType());
        record.setOwnerUserNo(param.getUserNo());
        record.setCreateItem("解绑银行卡");
        record.setOwnerBank(param.getOwnerAccountBank());
        record.setOpenAccountBank(param.getOwnerAccountBank());
        record.setAccountBankName(param.getOwnerAccountName());
        record.setCreateBy("曹做人");
        ownerBindCardRecordDao.saveEntity(record);

        ownerInfoFeign.unBindOwnerBindCard(param);
    }
}
