package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OwnerTransferInfo;
import com.clx.performance.param.pc.*;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.clx.user.param.pc.owner.UpdateOwnerBindCardFeignParam;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.util.List;

public interface OwnerAccountService {
    IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param);

    IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(PagePlatformMarginAccountParam param);

    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param);

    List<OwnerAccountVO> accountInfo(Long ownerUserNo);

    Long accountTopUp(OwnerTopUpParam param);

    Long accountCaseOut(OwnerCaseOutParam param);

    /**
     * 充值审批
     */
    void accountTopUpApprove(PlatformAccountTopUpParam param);

    /**
     * 提现审批
     * @param param
     */
    void accountCaseOutApprove(OwnerCaseOutApproveParam param);

    /**
     * 货主付款确认
     * @param id
     */
    void accountBalanceConfirm(Integer id);

    /**
     *保证金导出
     * @param param
     * @return
     */
    SXSSFWorkbook exportMarginAccountPageList(PagePlatformMarginAccountParam param);

    /**
     * 预付金导出
     * @param param
     * @return
     */
    SXSSFWorkbook exportPrepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param);

    OwnerTransferInfo transferPublic();

    OwnerBindCardVO getOwnerBindCard(Long userNo);

    void bindOwnerBindCard(UpdateOwnerBindCardFeignParam param);

    void unBindOwnerBindCard(UpdateOwnerBindCardFeignParam param);
}
