package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 货主结算单
* @Date: 2023/10/11 17:46:48
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
@Builder
@AllArgsConstructor
public class SettlementOwner implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long ownerUserNo;                       //货主用户编号
    private String ownerName;                       //货主名称
    private String settlementNo;                    //结算单编号
    private String settlementSubNo;                 //结算子单号
    private String orderNo;                         //订单编号
    private BigDecimal weight;                      //实际净重（吨）
    private BigDecimal freight;                     //实际运费（分）
    private BigDecimal lossWeight;                  //货损吨数（吨）
    private BigDecimal lossFreight;                 //货损金额（分）
    private BigDecimal prepayFreight;               //预付运费金额（分）
    private BigDecimal settlementFreight;           //结算金额（分）
    private Integer invoiceType;                    //开票标识：1网运单 2普通单
    private BigDecimal invoiceFreight;              //开票金额（分）
    private String invoiceImg;                      //结算凭证
    private String payee;                           //收款人
    private String payeeBankName;                   //收款银行
    private String payeeBankCardNo;                //收款银行卡卡号
    private String paymentImg;                      //付款凭证
    private String paymentBankName;                   //付款银行
    private String paymentBankCardNo;                //付款银行卡卡号
    private String companyName;                     //公司名称
    private String companyTaxCode;                  //企业税号
    private String companyAddress;                  //公司地址
    private String companyMobile;                   //公司电话
    private String companyBankName;                 //公司开户行
    private String companyBankNo;                   //公司银行账号
    private String companyContact;                  //公司联系人
    private String companyContactMobile;            //公司联系电话
    private String companyContactAddress;           //公司联系地址
    private String expressCompany;                  //快递公司
    private String expressNo;                       //快递编号
    private Integer invoiceStatus;                  //开票状态
    private Integer status;                         //状态
    private String remark;                         //备注
    private Integer mergeStatus;                         //是否合并 0-否，1-是
    private String mergedBy;                         //合并人
    private LocalDateTime mergeTime;                       //合并结算单时间
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}