package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主充值
 *
 * @date : 2023-10-12
 */

@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_top_up")
public class OwnerTopUp implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 充值编号
     */
    @TableField("owner_no")
    private Long topUpNo;
    /**
     * 货主编码
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;
    /**
     * 充值类型
     */
    @TableField("account_type")
    private Integer accountType;
    /**
     * 充值金额
     */
    @TableField("top_up_balance")
    private BigDecimal topUpBalance;
    /**
     * 状态
     */
    @TableField("status")
    private Integer status;
    /**
     * 打款银行
     */
    @TableField("drawing_bank")
    private String drawingBank;
    /**
     * 打款银行卡号
     */
    @TableField("drawing_bank_number")
    private String drawingBankNumber;
    /**
     * 打款凭证
     */
    @TableField("drawing_proof")
    private String drawingProof;
    /**
     * 操作时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;
    /**
     * 操作人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 审批时间
     */
    @TableField("approval_time")
    private LocalDateTime approvalTime;
    /**
     * 审批人
     */
    @TableField("approval_by")
    private String approvalBy;
    /**
     * 审批拒绝
     */
    @TableField("approval_turn_down")
    private String approvalTurnDown;

    /**
     * 修改时间
     */
    @TableField("modified_time")
    private LocalDateTime modifiedTime;
    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}