package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主提现;
 *
 * @date : 2023-10-12
 */

@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_case_out")
public class OwnerCaseOut implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 货主编号
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;

    /**
     * 提现编号
     */
    @TableField("case_out_no")
    private Long caseOutNo;
    /**
     * 账户类型  1: 保证金 2：预付运费
     */
    @TableField("account_type")
    private Integer accountType;
    /**
     * 提现金额
     */
    @TableField("case_out_balance")
    private BigDecimal caseOutBalance;
    /**
     * 状态
     */
    @TableField("status")
    private Integer status;
    /**
     * 提现银行
     */
    @TableField("case_out_bank")
    private String caseOutBank;
    /**
     * 提现银行卡号
     */
    @TableField("case_out_bank_number")
    private String caseOutBankNumber;
    /**
     * 操作人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 付款时间
     */
    @TableField("payment_time")
    private LocalDateTime paymentTime;
    /**
     * 平台付款银行
     */
    @TableField("platform_payment_bank")
    private String platformPaymentBank;
    /**
     * 平台付款银行账号
     */
    @TableField("platform_payment_bank_number")
    private String platformPaymentBankNumber;

    /**
     * 平台付款金额
     */
    @TableField("platform_pay_balance")
    private BigDecimal platformPayBalance;
    /**
     * 付款人
     */
    @TableField("payment_by")
    private String paymentBy;
    /**
     * 付款凭证
     */
    @TableField("payment_proof")
    private String paymentProof;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    @TableField("modify_time")
    private LocalDateTime modifyTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return id;
    }
}