package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主账户;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-10-12
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_account")
public class OwnerAccount implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 货主编码
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;
    /**
     * 货主名称
     */
    @TableField("owner_user_name")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @TableField("mobile")
    private Integer mobile;
    /**
     * 账户类型;1:保证金 2：预付运费
     */
    @TableField("account_type")
    private Integer accountType;
    /**
     * 账户余额
     */
    @TableField("account_balance")
    private BigDecimal accountBalance;
    /**
     * 可用余额
     */
    @TableField("usable_balance")
    private BigDecimal usableBalance;
    /**
     * 冻结金额
     */
    @TableField("frozen_balance")
    private BigDecimal frozenBalance;
    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}