package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dto.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.extranal.encrypt.EncryptService;
import com.clx.performance.sdk.callback.message.OrderChildMessage;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.clx.performance.sdk.constant.MessageConstants.*;

@Slf4j
@Component
@AllArgsConstructor
public class OrderChildDtsListener  {

    private final EncryptService encryptService;


    @RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_ORDER_CHILD_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.order_child, msg:{}", msg);

            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);

            OrderChildMessage before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new OrderChildMessage());
            OrderChildMessage after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new OrderChildMessage());

            if(Objects.equals(DtsOperationTypeEnum.INSERT.getCode(),dataTransportDTO.getOperationType().getCode())){
                //同步after数据
                log.info("新增:{}"+after);
                encryptService.encryptPost(APP_ID,APP_SECRET,ORDER_CHILD_INFO_SYNC_URL,JSON.toJSONString(after),after.topic());
            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    //同步after数据
                    log.info("修改:{}"+after);
                    encryptService.encryptPost(APP_ID,APP_SECRET,ORDER_CHILD_INFO_SYNC_URL,JSON.toJSONString(after),after.topic());
                }
            }else if(Objects.equals(DtsOperationTypeEnum.DELETE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                log.info("删除:{}"+before);
                encryptService.encryptPost(APP_ID,APP_SECRET,ORDER_CHILD_INFO_SYNC_URL,JSON.toJSONString(before),before.topic());
            }


        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.order_child, error:{}", e.getMessage());
        }
    }

}
