package com.clx.performance.extranal.encrypt.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.extranal.encrypt.EncryptService;
import com.google.gson.Gson;
import com.msl.common.dto.HttpDTO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import com.msl.common.utils.EncryptUtil;
import com.msl.common.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.security.GeneralSecurityException;

import static com.clx.user.enums.result.UserResultEnum.HTTP_ERROR;

@Service
@Slf4j
public class EncryptServiceImpl implements EncryptService {



     @Override
     public Result<?> encryptPost(String appId,String secret,String url,String param,String action) {
         log.info("开始请求交易平台接口,请求action:{},请求参数:{}",action,param);
        try {
            HttpDTO httpDTO = EncryptUtil.buildDTO(appId, param, secret, System.currentTimeMillis());
            httpDTO.setAction(action);
            return HttpUtil.post(url, null, httpDTO)
                    .map(r -> JSON.parseObject(r, new TypeReference<HttpDTO>() {
                    }))
                    .peek(dto -> log.info("http请求返回------dto->{}", dto))
                    .map(HttpDTO::getData)
                    .mapTry(d -> EncryptUtil.decrypt(d, secret))
                    .mapWithObj(new TypeReference<Result<Object>>() {
                    }, this::covertResult)
                    .orElseThrow(HTTP_ERROR);
        } catch (GeneralSecurityException e) {
            log.error("解密失败", e);
            throw new ServiceSystemException(HTTP_ERROR);
        }
    }

    private <T> Result<T> covertResult(String result, TypeReference<Result<T>> reference) {
        return new Gson().fromJson(result, reference.getType());
    }
}
