package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDao;
import com.clx.performance.mapper.settle.SettlementDriverMapper;
import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 车主结算单
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementDriverDaoImpl extends BaseDaoImpl<SettlementDriverMapper, SettlementDriver, Integer> implements SettlementDriverDao {



    @Override
    public IPage<SettlementDriver> pageCarrierSettlementDriver(PageCarrierSettlementDriverParam param) {
        LambdaQueryWrapper<SettlementDriver> query = new LambdaQueryWrapper<>();

        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementDriver :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderGoodsNo())){
            query.eq(SettlementDriver :: getOrderGoodsNo,param.getOrderGoodsNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementDriver :: getOrderNo,param.getOrderNo());
        }
        if(Objects.nonNull(param.getDriverUserNo())){
            query.eq(SettlementDriver :: getOrderNo,param.getOrderNo());
        }
        query.orderByDesc(SettlementDriver :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }
}
